/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.game.inventory;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.SelectBox;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.Tooltip;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.badlogic.gdx.utils.Array;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.datapack.game.mechanics.resources.Resource;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.InventoryListener;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.Item;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.ItemComparator;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.MultiStackInventory;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.TextButtonPalette;
import com.neutronio.astrax.ui.commons.action.CustomAction;
import com.neutronio.astrax.ui.commons.buttons.AstraXTextButton;
import com.neutronio.astrax.ui.commons.buttons.Button;
import com.neutronio.astrax.ui.commons.buttons.StaticIcon;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;
import com.neutronio.astrax.ui.commons.text.AstraXLabel;
import com.neutronio.astrax.ui.commons.text.TextProgressbar;
import com.neutronio.astrax.ui.commons.widgets.SelectBoxWrapper;
import com.neutronio.astrax.ui.editor.Palette;
import com.neutronio.astrax.ui.game.inventory.ItemInfoPanel;
import com.neutronio.astrax.util.StandardFormats;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class InventoryPanel
extends SimplePanel {
    private Logger logger = Logger.getLogger(this.getClass().getCanonicalName());
    private static String GAME_INVENTORY_DROP_ALL = "game_inventory_drop_all";
    private static String GAME_INVENTORY_DISCARD_ALL = "game_inventory_discard_all";
    private static String GAME_INVENTORY_MORE_INFO = "game_inventory_more_info";
    private static String GAME_INVENTORY_SORT_BY = "game_inventory_sort_by";
    protected TextButtonPalette<Item<Resource>> items;
    protected ItemInfoPanel itemInfoPanel;
    protected AstraXLabel nameValue;
    protected StaticIcon totalWeightIcon;
    protected TextProgressbar weightRatioBar;
    protected SelectBox<SelectBoxWrapper<ItemComparator.SortMode>> sortSelectBox;
    protected MultiStackInventory<Resource> inventory;
    protected InventoryListener<Resource> inventoryListener;
    protected InventoryPanelListener listener;
    private Tooltip<ItemInfoPanel> itemToolTip;
    private AstraXTextButton dropAllButton;
    private AstraXTextButton discardAllButton;
    private AstraXTextButton moreInfoButton;

    public InventoryPanel(ComponentFactory factory) {
        super(factory);
        this.sortSelectBox = new SelectBox(factory.getSkin());
        Array<SelectBoxWrapper<ItemComparator.SortMode>> sortModes = new Array<SelectBoxWrapper<ItemComparator.SortMode>>();
        for (ItemComparator.SortMode sortMode : ItemComparator.SortMode.values()) {
            sortModes.add(new SelectBoxWrapper<ItemComparator.SortMode>(sortMode.name(), sortMode));
        }
        this.sortSelectBox.setItems(sortModes);
        this.sortSelectBox.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                InventoryPanel.this.onSortingModeChanged(InventoryPanel.this.sortSelectBox.getSelected().getPayload(), false);
            }
        });
        this.inventoryListener = new InventoryListener<Resource>(){

            @Override
            public void onStackAdded(Item<Resource> stack) {
                InventoryPanel.this.logger.fine("On stack added: " + stack);
                InventoryPanel.this.items.addItem(stack, InventoryPanel.this.componentFactory.getSkin().getRegion(stack.getIcon()));
                InventoryPanel.this.items.updateToContent();
            }

            @Override
            public void onStackChanged(Item<Resource> stack) {
                InventoryPanel.this.logger.fine("On stack changed: " + stack);
                InventoryPanel.this.items.updateButton(stack);
            }

            @Override
            public void onStackRemoved(Item<Resource> stack) {
                InventoryPanel.this.logger.fine("On stack removed: " + stack);
                InventoryPanel.this.items.updateToContent();
            }
        };
        this.items = new TextButtonPalette(this.componentFactory);
        this.items.setButtonProducer(new Palette.ButtonUpdater<AstraXTextButton, Item<Resource>>(){

            @Override
            public AstraXTextButton createButton(ComponentFactory componentFactory, String style) {
                AstraXTextButton textButton = new AstraXTextButton(componentFactory, style);
                textButton.setTextAlign(12);
                return textButton;
            }

            @Override
            public void updateButton(AstraXTextButton button, Item<Resource> item) {
                button.setDisabled(false);
                button.setUserObject(item);
                button.setText(StandardFormats.FLOAT_COUNT.format(Float.valueOf(item.getAmount())));
                button.setInlineIcon(new TextureRegionDrawable(InventoryPanel.this.componentFactory.getSkin().getRegion(item.getIcon())));
            }

            @Override
            public void resetButton(AstraXTextButton button) {
                button.setText("");
                button.setInlineIcon(null);
                button.setUserObject(null);
                button.setDisabled(true);
            }
        });
        this.items.setColumns(8);
        this.items.setIconCount(32);
        this.items.getButtonGroup().setMinCheckCount(0);
        this.items.getButtonGroup().setMaxCheckCount(5);
        this.items.construct();
        this.items.fillWithButtons("inventory");
        this.items.setListener(new Palette.PaletteListener<Item<Resource>>(){

            @Override
            public void onSelectedChanged(Item<Resource> selectedItem) {
                InventoryPanel.this.itemInfoPanel.update(selectedItem);
            }
        });
        this.itemInfoPanel = new ItemInfoPanel(this.componentFactory, "inset");
        this.itemInfoPanel.align(10);
        this.itemToolTip = new Tooltip(this.itemInfoPanel){

            @Override
            public void enter(InputEvent event, float x, float y, int pointer, Actor fromActor) {
                if (event.getTarget() == null || event.getTarget().getUserObject() == null) {
                    return;
                }
                if (event.getTarget().getUserObject() instanceof Item) {
                    Item item = (Item)event.getTarget().getUserObject();
                    InventoryPanel.this.itemInfoPanel.update(item);
                }
                super.enter(event, x, y, pointer, fromActor);
            }
        };
        for (AstraXTextButton textButton : this.items.getButtons()) {
            textButton.addListener(this.itemToolTip);
        }
        Table weightGroup = new Table();
        weightGroup.align(8);
        this.nameValue = this.getHeader2("-");
        this.nameValue.setWidth(300.0f);
        weightGroup.add(this.nameValue).minWidth(300.0f).space(10.0f);
        this.weightRatioBar = new TextProgressbar(this.componentFactory);
        this.weightRatioBar.setFormat(StandardFormats.WEIGHT);
        this.weightRatioBar.setValue(0.0f);
        weightGroup.add(this.weightRatioBar).minWidth(150.0f);
        this.totalWeightIcon = new StaticIcon(this.componentFactory.getSkin(), "empty");
        this.totalWeightIcon.setInlineIcon("icon_inline_weight");
        weightGroup.add(this.totalWeightIcon);
        HorizontalGroup sortGroup = new HorizontalGroup();
        sortGroup.space(10.0f);
        sortGroup.right();
        sortGroup.addActor(this.getLabel(factory.translate(GAME_INVENTORY_SORT_BY)));
        sortGroup.addActor(this.sortSelectBox);
        HorizontalGroup buttonGroup = new HorizontalGroup();
        buttonGroup.space(10.0f);
        this.dropAllButton = new AstraXTextButton(factory, "secondary-compact");
        this.dropAllButton.setText(factory.translate(GAME_INVENTORY_DROP_ALL));
        this.dropAllButton.setCanCheck(false);
        this.dropAllButton.setButtonAction(CustomAction.get(new Runnable(){

            @Override
            public void run() {
                AstraXApp.astraX.showInfoAlert("Feature not supported yet!");
                if (InventoryPanel.this.listener == null) {
                    return;
                }
                ArrayList<Item<Resource>> itemsDropped = new ArrayList<Item<Resource>>();
                for (Button button : InventoryPanel.this.items.getButtonGroup().getButtons()) {
                    Actor buttonActor = (Actor)((Object)button);
                    if (buttonActor.getUserObject() instanceof Item) {
                        Item item = (Item)buttonActor.getUserObject();
                        itemsDropped.add(item);
                    }
                    InventoryPanel.this.listener.onItemsDropped(itemsDropped);
                }
            }
        }));
        this.discardAllButton = new AstraXTextButton(factory, "secondary-compact");
        this.discardAllButton.setText(factory.translate(GAME_INVENTORY_DISCARD_ALL));
        this.discardAllButton.setCanCheck(false);
        this.discardAllButton.setButtonAction(CustomAction.get(new Runnable(){

            @Override
            public void run() {
                AstraXApp.astraX.showInfoAlert("Feature not supported yet!");
                if (InventoryPanel.this.listener == null) {
                    return;
                }
                ArrayList<Item<Resource>> itemsDropped = new ArrayList<Item<Resource>>();
                for (Button button : InventoryPanel.this.items.getButtonGroup().getButtons()) {
                    Actor buttonActor = (Actor)((Object)button);
                    if (buttonActor.getUserObject() instanceof Item) {
                        Item item = (Item)buttonActor.getUserObject();
                        itemsDropped.add(item);
                    }
                    InventoryPanel.this.listener.onItemsDiscarded(itemsDropped);
                }
            }
        }));
        this.moreInfoButton = new AstraXTextButton(factory, "secondary-compact");
        this.moreInfoButton.setText(factory.translate(GAME_INVENTORY_MORE_INFO));
        this.moreInfoButton.setCanCheck(false);
        this.moreInfoButton.setButtonAction(CustomAction.get(new Runnable(){

            @Override
            public void run() {
                AstraXApp.astraX.showInfoAlert("Feature not supported yet!");
            }
        }));
        buttonGroup.addActor(this.dropAllButton);
        buttonGroup.addActor(this.discardAllButton);
        buttonGroup.addActor(this.moreInfoButton);
        this.add(weightGroup).fill().padBottom(this.panelStyle.rowPadding).padRight(this.panelStyle.columnPadding).colspan(2);
        this.row();
        this.addValue(sortGroup, 2);
        this.row();
        this.addValue(this.items, 1);
        this.row();
        this.addValue(buttonGroup, 2);
        this.pack();
    }

    private void onSortingModeChanged(ItemComparator.SortMode sortMode, boolean ascending) {
        this.inventory.sort(sortMode, ascending);
        this.updateWith(this.inventory);
    }

    public void updateWith(MultiStackInventory<Resource> inventory) {
        if (this.inventory != null) {
            this.inventory.setListener(null);
        }
        this.inventory = inventory;
        this.items.clearItems();
        this.itemInfoPanel.update(null);
        this.items.deselect();
        if (inventory == null) {
            this.items.updateToContent();
            this.weightRatioBar.setBaseValue(0.0f);
            this.weightRatioBar.setValue(0.0f);
            return;
        }
        for (int i2 = 0; i2 < inventory.size(); ++i2) {
            this.items.addItem(inventory.get(i2), this.componentFactory.getSkin().getRegion(inventory.get(i2).getIcon()));
        }
        this.items.updateToContent();
        inventory.setListener(this.inventoryListener);
        this.weightRatioBar.setBaseValue(inventory.getMaxWeight());
        this.weightRatioBar.setValue(inventory.getWeight() / inventory.getMaxWeight());
        this.nameValue.setText(inventory.getName());
        this.pack();
    }

    public static interface InventoryPanelListener {
        public void onItemsDropped(List<Item<Resource>> var1);

        public void onItemsDiscarded(List<Item<Resource>> var1);
    }
}

