/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.game.inventory;

import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextArea;
import com.badlogic.gdx.scenes.scene2d.ui.Tooltip;
import com.neutronio.astrax.app.datapack.game.mechanics.resources.Resource;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.Item;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.buttons.StaticIcon;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;
import com.neutronio.astrax.ui.commons.text.AstraXLabel;
import com.neutronio.astrax.util.StandardFormats;

public class ItemInfoPanel
extends SimplePanel {
    public static final String WEIGHT_HINT = "Single / stack weight in tons.";
    public static final String VALUE_HINT = "Single / stack value in chips";
    private static String weightFormat = "%s (%s)";
    protected AstraXLabel nameValue;
    protected TextArea descriptionValue;
    protected AstraXLabel weightValue;
    protected StaticIcon weightIcon;
    protected AstraXLabel valueValue;
    protected StaticIcon valueIcon;
    protected StaticIcon cargoIcon;

    public ItemInfoPanel(ComponentFactory componentFactory, String backgroundStyle) {
        super(componentFactory, "detailpanel", backgroundStyle);
        this.descriptionValue = new TextArea("", componentFactory.getSkin(), "editor");
        this.descriptionValue.setDisabled(true);
        this.descriptionValue.setPrefRows(5.0f);
        Table itemHeader = new Table();
        this.nameValue = this.getHeader2("");
        this.cargoIcon = new StaticIcon(componentFactory.getSkin(), "clear");
        this.cargoIcon.setInlineIcon("icon_function_cargo");
        itemHeader.add(this.cargoIcon).padRight(5.0f);
        itemHeader.add(this.nameValue).minWidth(200.0f);
        this.addValue(itemHeader, 2);
        this.row();
        this.addValue(this.descriptionValue, 2);
        this.row();
        Tooltip<AstraXLabel> weightTooltip = componentFactory.getToolTip(WEIGHT_HINT);
        this.weightValue = this.addLabel(String.format(weightFormat, "-", "-"));
        this.weightValue.addListener(weightTooltip);
        this.weightIcon = new StaticIcon(componentFactory.getSkin(), "secondary");
        this.weightIcon.setInlineIcon("icon_inline_weight");
        this.weightIcon.addListener(weightTooltip);
        this.addValueCentered(this.weightIcon);
        this.row();
        Tooltip<AstraXLabel> valueTooltip = componentFactory.getToolTip(VALUE_HINT);
        this.valueValue = this.addLabel(String.format(weightFormat, "-", "-"));
        this.valueValue.addListener(valueTooltip);
        this.valueIcon = new StaticIcon(componentFactory.getSkin(), "secondary");
        this.valueIcon.setInlineIcon("icon_inline_coins");
        this.valueIcon.addListener(valueTooltip);
        this.addValueCentered(this.valueIcon);
        this.pack();
    }

    public void update(Item<Resource> item) {
        if (item == null) {
            this.nameValue.setText("-");
            this.descriptionValue.setText("-");
            this.weightValue.setText(String.format(weightFormat, "-", "-"));
            this.valueValue.setText(String.format(weightFormat, "-", "-"));
            return;
        }
        this.nameValue.setText(item.getName());
        this.descriptionValue.setText(item.getObject().description);
        this.weightValue.setText(String.format(weightFormat, StandardFormats.WEIGHT.format(Float.valueOf(item.getWeight())), StandardFormats.WEIGHT.format(Float.valueOf(item.getStackWeight()))));
        this.valueValue.setText(String.format(weightFormat, StandardFormats.MONEY_ITEM.format(Float.valueOf(item.basePrice)), StandardFormats.MONEY_ITEM.format(Float.valueOf(item.getStackValue()))));
    }
}

