/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.game.menu;

import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.panels.AbstractPanel;
import com.neutronio.astrax.util.StandardFormats;

public class GalaxyDetail
extends AbstractPanel {
    private Label galaxyNameValue;
    private Label galaxyTypeValue;
    private Label systemCountValue;
    private Label yCoordinateValue;
    private Label xCoordinateValue;

    public GalaxyDetail(ComponentFactory componentFactory) {
        super(componentFactory);
        this.galaxyNameValue = new Label((CharSequence)"-", this.panelStyle.labelStyle);
        this.galaxyTypeValue = new Label((CharSequence)"-", this.panelStyle.labelStyle);
        this.systemCountValue = new Label((CharSequence)"-", this.panelStyle.labelStyle);
        this.yCoordinateValue = new Label((CharSequence)"-", this.panelStyle.labelStyle);
        this.xCoordinateValue = new Label((CharSequence)"-", this.panelStyle.labelStyle);
    }

    @Override
    public void resetValues() {
        this.galaxyNameValue.setText("-");
        this.galaxyTypeValue.setText("-");
        this.systemCountValue.setText("-");
        this.xCoordinateValue.setText("");
        this.yCoordinateValue.setText("");
    }

    @Override
    public void construct() {
        super.construct();
        this.clear();
        this.addRow("Name", this.galaxyNameValue, 1);
        this.row();
        this.addRow("Type", this.galaxyTypeValue, 1);
        this.row();
        this.addRow("System Count", this.systemCountValue, 1);
        this.row();
        Table coordinateTable = new Table();
        coordinateTable.add(this.xCoordinateValue).minWidth((float)this.panelStyle.minValueWidth / 2.0f).fill();
        coordinateTable.add(this.yCoordinateValue).minWidth((float)this.panelStyle.minValueWidth / 2.0f).padLeft(this.panelStyle.columnPadding).fill();
        this.addRow("Coordinates", coordinateTable, 1);
        this.row();
        this.pack();
    }

    public void update(String name, String galaxyType, int systemCount) {
        this.galaxyNameValue.setText(name);
        this.galaxyTypeValue.setText(galaxyType);
        this.systemCountValue.setText("ca. " + StandardFormats.MONEY_HUD.format(systemCount));
        this.pack();
    }

    public void updateCoordinates(int xSector, int ySector) {
        this.xCoordinateValue.setText(xSector + "");
        this.yCoordinateValue.setText(ySector + "");
    }
}

