/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.game.menu;

import com.neutronio.astrax.app.datapack.game.DiscoveryTarget;
import com.neutronio.astrax.app.datapack.game.world.galaxy.Galaxy;
import com.neutronio.astrax.app.datapack.game.world.galaxy.Sector;
import com.neutronio.astrax.app.datapack.game.world.galaxy.StarSystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.targeting.DiscoverySystem;
import com.neutronio.astrax.io.sql.GameDatabase;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.buttons.AstraXButton;
import com.neutronio.astrax.ui.commons.buttons.Button;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;
import com.neutronio.astrax.ui.commons.tab.FlexTab;
import com.neutronio.astrax.ui.game.menu.StarMap;
import com.neutronio.astrax.ui.game.menu.TabbedGameMenu;
import com.neutronio.astrax.ui.game.menu.map.bookmarks.BookmarkTab;
import com.neutronio.astrax.ui.game.menu.map.galaxy.GalaxyMap;
import java.util.List;

public class MapTab
extends SimplePanel
implements TabbedGameMenu.GameMenuTab {
    private DiscoverySystem discoverySystem;
    private DiscoveryTarget self;
    private FlexTab flexTab;
    private GalaxyMap galaxyMap;
    private StarMap starMap;
    private BookmarkTab bookmarkTab;

    public MapTab(ComponentFactory factory, GameDatabase database) {
        super(factory, "default", "panel-tech-deco2");
        this.galaxyMap = new GalaxyMap(factory, database);
        this.galaxyMap.construct();
        this.starMap = new StarMap(factory);
        this.bookmarkTab = new BookmarkTab(this.componentFactory);
        this.flexTab = new FlexTab(this.componentFactory);
        AstraXButton galaxyMapButton = this.flexTab.addTabWithIconButton("secondary-48x48", "icon_inline_galaxy", this.galaxyMap);
        AstraXButton starMapButton = this.flexTab.addTabWithIconButton("secondary-48x48", "icon_inline_orbit", this.starMap);
        AstraXButton bookmarkButton = this.flexTab.addTabWithIconButton("secondary-48x48", "icon_inline_bookmark", this.bookmarkTab);
        galaxyMapButton.addListener(factory.getToolTip(this.getTranslation("game_map_galaxy")));
        starMapButton.addListener(factory.getToolTip(this.getTranslation("game_map_system")));
        bookmarkButton.addListener(factory.getToolTip(this.getTranslation("game_map_bookmarks")));
        this.flexTab.construct();
        this.flexTab.getStackController().show(0);
        this.add(this.flexTab.getContentStack());
    }

    @Override
    public List<Button> getControlButtons() {
        return this.flexTab.getTabButtons();
    }

    public BookmarkTab getBookmarkTab() {
        return this.bookmarkTab;
    }

    public GalaxyMap getGalaxyMap() {
        return this.galaxyMap;
    }

    public StarMap getStarMap() {
        return this.starMap;
    }

    public void update(Sector<StarSystem> starSystemSector) {
        this.updatePosition(starSystemSector.getXCoordinates(), starSystemSector.getYCoordinates());
    }

    public void updateSelectedInfo(DiscoveryTarget discoveryTarget) {
        this.starMap.select(discoveryTarget);
    }

    public void updatePosition(int sectorX, int sectorY) {
        this.galaxyMap.setPosition(sectorX, sectorY);
    }

    public void discoverTarget(DiscoveryTarget target) {
        this.starMap.discoverTarget(target);
    }

    public void setGalaxy(Galaxy galaxy) {
        this.galaxyMap.setGalaxy(galaxy);
    }

    public void setSelf(DiscoveryTarget self) {
        this.self = self;
        this.starMap.setSelf(self);
    }

    public void setDiscoverySystem(DiscoverySystem discoverySystem) {
        this.discoverySystem = discoverySystem;
        this.starMap.setDiscoverySystem(discoverySystem);
    }

    public void onStarSystemChanged(Sector<StarSystem> starSystem) {
        this.galaxyMap.setCurrentCoordinates(starSystem.getXCoordinates(), starSystem.getYCoordinates());
        this.starMap.onStarSystemChanged(starSystem);
    }
}

