/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.game.menu;

import com.badlogic.gdx.Gdx;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.datapack.GameSessionFactory;
import com.neutronio.astrax.app.screen.MainMenuScreen;
import com.neutronio.astrax.app.screen.SpaceScreen;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.action.CustomAction;
import com.neutronio.astrax.ui.commons.buttons.AstraXTextButton;
import com.neutronio.astrax.ui.commons.buttons.Button;
import com.neutronio.astrax.ui.commons.buttons.ButtonList;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;
import com.neutronio.astrax.ui.commons.text.AstraXLabel;
import com.neutronio.astrax.ui.game.menu.TabbedGameMenu;
import java.util.ArrayList;
import java.util.List;

public class MenuTab
extends SimplePanel
implements TabbedGameMenu.GameMenuTab {
    protected ButtonList<AstraXTextButton> menu;

    public MenuTab(ComponentFactory componentFactory) {
        super(componentFactory, "default", "tab-inner");
        this.menu = new ButtonList(componentFactory);
        this.menu.addEntry(new AstraXTextButton(componentFactory, this.getTranslation("menu_resume"), null, "menu"), CustomAction.get(new Runnable(){

            @Override
            public void run() {
                AstraXApp.astraX.getScreen(SpaceScreen.class).hideTabMenu();
                AstraXApp.astraX.getScreen(SpaceScreen.class).gainFocusPlayer();
            }
        }));
        this.menu.addEntry(new AstraXTextButton(componentFactory, this.getTranslation("menu_exit_to_main"), null, "menu"), CustomAction.get(new Runnable(){

            @Override
            public void run() {
                SpaceScreen screen = AstraXApp.astraX.getScreen(SpaceScreen.class);
                AstraXApp.astraX.getFactoryByClass(GameSessionFactory.class).saveGame(screen.getAstraxGame(), screen.getAstraxGame().getWorld());
                screen.dispose();
                AstraXApp.astraX.getInputMultiplexer().clear();
                AstraXApp.astraX.getScreen(MainMenuScreen.class).resetScreenState();
                AstraXApp.astraX.setScreen(MainMenuScreen.class);
                SpaceScreen newScreen = new SpaceScreen(AstraXApp.astraX);
                AstraXApp.astraX.addScreen(newScreen);
            }
        }));
        this.menu.addEntry(new AstraXTextButton(componentFactory, this.getTranslation("menu_exit_to_desktop"), null, "menu-red"), CustomAction.get(new Runnable(){

            @Override
            public void run() {
                SpaceScreen screen = AstraXApp.astraX.getScreen(SpaceScreen.class);
                AstraXApp.astraX.getFactoryByClass(GameSessionFactory.class).saveGame(screen.getAstraxGame(), screen.getAstraxGame().getWorld());
                Gdx.app.exit();
            }
        }));
        this.menu.pack();
        this.menu.construct();
        this.construct();
        AstraXLabel hintLabel = this.getLabel(this.getTranslation("game_menu_main_hint"));
        this.addValue(hintLabel).padBottom(30.0f).row();
        this.addValue(this.menu);
        this.pack();
    }

    @Override
    public List<Button> getControlButtons() {
        return new ArrayList<Button>();
    }
}

