/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.game.menu;

import com.neutronio.astrax.app.ApplicationSettings;
import com.neutronio.astrax.app.KeyMappingSettings;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.buttons.Button;
import com.neutronio.astrax.ui.commons.forms.AbstractForm;
import com.neutronio.astrax.ui.commons.forms.GenericMultiFormContainer;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;
import com.neutronio.astrax.ui.game.GameSettingsPanel;
import com.neutronio.astrax.ui.game.InputControlsForm;
import com.neutronio.astrax.ui.game.SkinSettingsForm;
import com.neutronio.astrax.ui.game.menu.TabbedGameMenu;
import java.util.ArrayList;
import java.util.List;

public class SettingsTab
extends SimplePanel
implements TabbedGameMenu.GameMenuTab {
    private GenericMultiFormContainer multiFormContainer;
    private GameSettingsPanel gameSettingsPanel;
    private InputControlsForm inputControlsForm;
    private SkinSettingsForm skinSettingsForm;

    public SettingsTab(ComponentFactory factory, String style) {
        super(factory, "default", "panel-tech-deco2");
        this.gameSettingsPanel = new GameSettingsPanel(factory, "default", "outset");
        this.gameSettingsPanel.construct();
        this.gameSettingsPanel.setName(this.getTranslation("settings_general"));
        this.inputControlsForm = new InputControlsForm(factory, "default", "outset");
        this.inputControlsForm.construct();
        this.inputControlsForm.setName(this.getTranslation("settings_controls"));
        this.skinSettingsForm = new SkinSettingsForm(factory, "default", "outset");
        this.skinSettingsForm.construct();
        this.skinSettingsForm.setName(this.getTranslation("settings_gui"));
        ArrayList<AbstractForm> forms = new ArrayList<AbstractForm>();
        forms.add(this.gameSettingsPanel);
        forms.add(this.skinSettingsForm);
        forms.add(this.inputControlsForm);
        this.multiFormContainer = GenericMultiFormContainer.createFormContainer(this.componentFactory, forms, true, null, "form_reset", "form_save");
        this.add(this.multiFormContainer).top().fill();
    }

    public SettingsTab(ComponentFactory factory) {
        this(factory, "solid");
    }

    @Override
    public List<Button> getControlButtons() {
        return this.multiFormContainer.getTabButtons();
    }

    public GenericMultiFormContainer getMultiFormContainer() {
        return this.multiFormContainer;
    }

    public void applyStarterValues(ApplicationSettings applicationSettings) {
        this.gameSettingsPanel.load(applicationSettings.generalSettings);
        this.inputControlsForm.load(applicationSettings.keyMappingSettings);
        this.skinSettingsForm.load(applicationSettings.skinSettings);
    }

    public ApplicationSettings getObject() {
        ApplicationSettings applicationSettings = new ApplicationSettings();
        KeyMappingSettings keyMappingSettings = new KeyMappingSettings();
        this.gameSettingsPanel.applyValuesTo(applicationSettings.generalSettings);
        this.inputControlsForm.applyValuesTo(keyMappingSettings);
        applicationSettings.keyMappingSettings = keyMappingSettings;
        return applicationSettings;
    }

    public InputControlsForm getInputControlsForm() {
        return this.inputControlsForm;
    }

    public void setInputControlsForm(InputControlsForm inputControlsForm) {
        this.inputControlsForm = inputControlsForm;
    }
}

