/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.game.menu;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.neutronio.astrax.app.datapack.game.DiscoveryTarget;
import com.neutronio.astrax.app.datapack.game.world.Targetable;
import com.neutronio.astrax.app.datapack.game.world.galaxy.Sector;
import com.neutronio.astrax.app.datapack.game.world.galaxy.StarSystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.targeting.DiscoverySystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.targeting.NavigationBookmark;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;
import com.neutronio.astrax.ui.game.DiscoveryPanel;
import com.neutronio.astrax.ui.game.menu.map.starmap.StarMapCanvas;
import com.neutronio.astrax.ui.game.menu.map.starmap.StarMapControlButtons;
import com.neutronio.astrax.ui.game.menu.map.starmap.StarMapControlButtonsListener;
import java.util.List;
import java.util.logging.Logger;

public class StarMap
extends SimplePanel {
    private ComponentFactory componentFactory;
    private DiscoverySystem discoverySystem;
    private DiscoveryTarget self;
    private Logger logger = Logger.getLogger(this.getClass().getCanonicalName());
    private DiscoveryPanel discoveryPanel;
    private StarMapCanvas starMapCanvas;
    private StarMapControlButtons controlButtons;
    private ClickListener planetButtonListener;
    private StarMapListener listener;

    public StarMap(ComponentFactory componentFactory) {
        super(componentFactory);
        this.componentFactory = componentFactory;
        this.discoveryPanel = new DiscoveryPanel(componentFactory);
        this.discoveryPanel.align(2);
        this.planetButtonListener = new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                super.clicked(event, x, y);
                StarMap.this.logger.finest("Target clicked: " + event.getTarget().getClass());
                StarMap.this.logger.finest("Target clicked: " + event.getTarget().getUserObject());
                StarMap.this.logger.finest("---- ");
                StarMap.this.select((DiscoveryTarget)event.getTarget().getUserObject());
                event.stop();
            }
        };
        this.starMapCanvas = new StarMapCanvas(this.planetButtonListener, componentFactory);
        this.controlButtons = new StarMapControlButtons(componentFactory, this.starMapCanvas.getZoomer(), componentFactory.getButtonSoundListener("starMap"));
        this.controlButtons.setControlListener(new StarMapControlButtonsListener(){

            @Override
            public void onFocusChangedToPlayer() {
            }

            @Override
            public void onFocusChangedToCurrentTarget() {
                if (StarMap.this.discoverySystem.getTargetComputer().getCurrentTarget() != null) {
                    // empty if block
                }
            }
        });
        this.addValue(this.controlButtons);
        this.row();
        this.addValue(this.starMapCanvas).size(ComponentFactory.SECONDARY_TAB_WIDTH, ComponentFactory.SECONDARY_TAB_HEIGHT).padRight(20.0f);
        this.addValue(this.discoveryPanel).top();
        this.setSize((float)Gdx.graphics.getWidth() * 0.9f, 600.0f);
    }

    public StarMapListener getListener() {
        return this.listener;
    }

    public void setListener(StarMapListener listener) {
        this.listener = listener;
    }

    @Deprecated
    public void addDiscoveredTarget(Targetable target) {
    }

    public void discoverTarget(DiscoveryTarget target) {
        this.getStarMap().addTarget(target);
    }

    public void onStarSystemChanged(Sector<StarSystem> starSystem) {
        this.starMapCanvas.setStarSystem(starSystem);
        this.starMapCanvas.onStarSystemChanged();
        this.starMapCanvas.setSelf(this.self);
    }

    public StarMapCanvas getStarMap() {
        return this.starMapCanvas;
    }

    public DiscoverySystem getDiscoverySystem() {
        return this.discoverySystem;
    }

    public void setSelf(DiscoveryTarget self) {
        this.self = self;
        this.starMapCanvas.setSelf(self);
    }

    public StarMapCanvas getStarMapCanvas() {
        return this.starMapCanvas;
    }

    public DiscoveryPanel getDiscoveryPanel() {
        return this.discoveryPanel;
    }

    public void setDiscoverySystem(DiscoverySystem discoverySystem) {
        this.discoverySystem = discoverySystem;
    }

    public void select(DiscoveryTarget toSelect) {
        if (this.discoverySystem != null) {
            this.discoverySystem.getTargetComputer().setCurrentTarget(toSelect, StarMap.class);
        }
        if (toSelect != null) {
            assert (this.discoverySystem != null);
            List<String> icons = this.discoverySystem.getDatabank().getIconsFor(toSelect.target.getID());
            this.discoveryPanel.update(toSelect);
            this.discoveryPanel.updateChildDiscoveries(icons);
            this.starMapCanvas.getOrbitRenderer().setSelectedTarget(toSelect != null ? toSelect.target.getID() : null);
        } else {
            this.discoveryPanel.update(null);
            this.starMapCanvas.getOrbitRenderer().setSelectedTarget(null);
        }
    }

    public static interface StarMapListener {
        public void onBookmarkAdded(NavigationBookmark var1);
    }
}

