/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.game.menu;

import com.neutronio.astrax.app.datapack.game.mechanics.resources.Resource;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.Cargobay;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.trade.TradeSystem;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.buttons.Button;
import com.neutronio.astrax.ui.commons.forms.AbstractForm;
import com.neutronio.astrax.ui.commons.forms.DefaultFormListener;
import com.neutronio.astrax.ui.commons.forms.GenericFormContainer;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;
import com.neutronio.astrax.ui.commons.tab.FlexTab;
import com.neutronio.astrax.ui.game.menu.TabbedGameMenu;
import com.neutronio.astrax.ui.game.trade.BuyForm;
import com.neutronio.astrax.ui.game.trade.SellForm;
import java.util.List;

public class StationTab
extends SimplePanel
implements TabbedGameMenu.GameMenuTab {
    private FlexTab flexTab;
    private TradeSystem merchant;
    private TradeSystem player;
    private GenericFormContainer<BuyForm> buyFormContainer;
    private GenericFormContainer<SellForm> sellFormContainer;
    private StationTabListener listener;

    public StationTab(ComponentFactory factory) {
        super(factory, "default", "panel-tech-deco2");
        BuyForm buyForm = new BuyForm(this.componentFactory);
        SellForm sellForm = new SellForm(this.componentFactory);
        this.buyFormContainer = GenericFormContainer.createFormContainer(this.componentFactory, buyForm, null, "form_reset", "form_submit");
        this.buyFormContainer.getFormController().addListener(new DefaultFormListener(){

            @Override
            public void onFormSubmit(AbstractForm form) {
                super.onFormSubmit(form);
                if (StationTab.this.listener != null) {
                    StationTab.this.listener.onBuyTransactionInitiated(StationTab.this.merchant, StationTab.this.player, ((BuyForm)StationTab.this.buyFormContainer.getForm()).getItemsToBuy());
                    ((BuyForm)StationTab.this.buyFormContainer.getForm()).resetForm();
                    StationTab.this.updateHard();
                }
            }

            @Override
            public void onFormReset(AbstractForm form) {
                super.onFormReset(form);
                ((BuyForm)StationTab.this.buyFormContainer.getForm()).resetForm();
            }
        });
        this.sellFormContainer = GenericFormContainer.createFormContainer(this.componentFactory, sellForm, null, "form_reset", "form_submit");
        this.sellFormContainer.getFormController().addListener(new DefaultFormListener(){

            @Override
            public void onFormSubmit(AbstractForm form) {
                super.onFormSubmit(form);
                if (StationTab.this.listener != null) {
                    StationTab.this.listener.onSellTransactionInitiated(StationTab.this.merchant, StationTab.this.player, ((SellForm)StationTab.this.sellFormContainer.getForm()).getItemsToSell());
                    ((SellForm)StationTab.this.sellFormContainer.getForm()).resetForm();
                    StationTab.this.updateHard();
                }
            }

            @Override
            public void onFormReset(AbstractForm form) {
                super.onFormReset(form);
                ((SellForm)StationTab.this.sellFormContainer.getForm()).resetForm();
            }
        });
        this.flexTab = new FlexTab(this.componentFactory);
        this.flexTab.addTabWithTextButton("Buy Items", "secondary-tab", this.buyFormContainer);
        this.flexTab.addTabWithTextButton("Sell Items", "secondary-tab", this.sellFormContainer);
        this.flexTab.getStackController().show(0);
        this.add(this.flexTab.getContentStack());
    }

    private StationTabListener getListener() {
        return this.listener;
    }

    public void setListener(StationTabListener listener) {
        this.listener = listener;
    }

    @Override
    public List<Button> getControlButtons() {
        return this.flexTab.getTabButtons();
    }

    public void setTradingParties(TradeSystem vendor, TradeSystem player) {
        this.merchant = vendor;
        this.player = player;
        this.buyFormContainer.getForm().setMerchant(vendor.getTrader());
        this.buyFormContainer.getForm().setPlayer(player.getTrader());
        this.buyFormContainer.getForm().update();
        this.sellFormContainer.getForm().setMerchant(vendor.getTrader());
        this.sellFormContainer.getForm().setPlayer(player.getTrader());
        this.sellFormContainer.getForm().update();
    }

    public void update() {
        this.buyFormContainer.getForm().update();
        this.sellFormContainer.getForm().update();
    }

    public void updateHard() {
        this.buyFormContainer.getForm().setMerchant(this.merchant.getTrader());
        this.buyFormContainer.getForm().setPlayer(this.player.getTrader());
        this.sellFormContainer.getForm().setMerchant(this.merchant.getTrader());
        this.sellFormContainer.getForm().setPlayer(this.player.getTrader());
    }

    public static interface StationTabListener {
        public void onBuyTransactionInitiated(TradeSystem var1, TradeSystem var2, Cargobay<Resource> var3);

        public void onSellTransactionInitiated(TradeSystem var1, TradeSystem var2, Cargobay<Resource> var3);
    }
}

