/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.game.menu;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.KeyMappingSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.Galaxy;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.CargoSystem;
import com.neutronio.astrax.app.screen.SpaceScreen;
import com.neutronio.astrax.io.sql.GameDatabase;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.buttons.AstraXButton;
import com.neutronio.astrax.ui.commons.buttons.AstraXTextButton;
import com.neutronio.astrax.ui.commons.buttons.Button;
import com.neutronio.astrax.ui.commons.forms.AbstractForm;
import com.neutronio.astrax.ui.commons.forms.DefaultFormListener;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;
import com.neutronio.astrax.ui.commons.tab.FlexTab;
import com.neutronio.astrax.ui.commons.text.Wiki;
import com.neutronio.astrax.ui.game.GameSettingsPanel;
import com.neutronio.astrax.ui.game.InputControlsForm;
import com.neutronio.astrax.ui.game.SkinSettingsForm;
import com.neutronio.astrax.ui.game.inventory.CargoSystemPanel;
import com.neutronio.astrax.ui.game.menu.MapTab;
import com.neutronio.astrax.ui.game.menu.MenuTab;
import com.neutronio.astrax.ui.game.menu.SettingsTab;
import com.neutronio.astrax.ui.game.menu.SpacecraftTab;
import com.neutronio.astrax.ui.game.menu.StarMap;
import com.neutronio.astrax.ui.game.menu.StationTab;
import com.neutronio.astrax.util.animation.Tweening;
import java.util.List;

public class TabbedGameMenu
extends FlexTab {
    private static String INTRO_HELPTEXT_HEADER = "introHelpText_header";
    private static String INTRO_HELPTEXT = "introHelpText";
    private static String DOCKING_HELPTEXT_HEADER = "dockingHelpText_header";
    private static String DOCKING_HELPTEXT = "dockingHelpText";
    private static String MINING_HELPTEXT_HEADER = "miningHelpText_header";
    private static String MINING_HELPTEXT = "miningHelpText";
    private static String NAVIGATION_HELPTEXT_HEADER = "navigationHelpText_header";
    private static String NAVIGATION_HELPTEXT = "navigationHelpText";
    private static String SECTOR_HELPTEXT_HEADER = "sectorHelpText_header";
    private static String SECTOR_HELPTEXT = "sectorHelpText";
    private static String CONTROLS_HELPTEXT_HEADER = "controlsHelpText_header";
    private static String CONTROLS_HELPTEXT = "controlsHelpText";
    private MenuTab mainMenuTab;
    private MapTab mapTab;
    private SpacecraftTab spacecraftTab;
    private CargoSystemPanel cargoSystemPanel;
    private StationTab stationTab;
    private SettingsTab settingsTab;
    private Wiki helpTab;
    private SimplePanel primaryButtonGroup;
    private SimplePanel secondaryButtonGroup;
    private ClickListener clickListener;
    private AstraXTextButton mainMenuButton;
    private AstraXTextButton mapButton;
    private AstraXTextButton spacecraftButton;
    private AstraXTextButton cargoButton;
    private AstraXTextButton stationButton;
    private AstraXButton settingsButton;
    private AstraXButton helpButton;

    public TabbedGameMenu(ComponentFactory factory, GameDatabase gameDatabase) {
        super(factory, "tab");
        KeyMappingSettings.KeyMapping contextAction = AstraXApp.astraX.getApplicationSettings().keyMappingSettings.getMapping("astrax:contextAction");
        KeyMappingSettings.KeyMapping changeTargetAction = AstraXApp.astraX.getApplicationSettings().keyMappingSettings.getMapping("astrax:changeTarget");
        KeyMappingSettings.KeyMapping toggleDrillAction = AstraXApp.astraX.getApplicationSettings().keyMappingSettings.getMapping("astrax:toggleDrill");
        this.clickListener = new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                super.clicked(event, x, y);
                TabbedGameMenu.this.updateSecondaryMenu();
            }
        };
        this.primaryButtonGroup = new SimplePanel(this.componentFactory, "default", null);
        this.primaryButtonGroup.pad(5.0f);
        this.secondaryButtonGroup = new SimplePanel(this.componentFactory, "default", null);
        this.stackController.setCyclic(true);
        this.mainMenuTab = new MenuTab(this.componentFactory);
        this.mapTab = new MapTab(this.componentFactory, gameDatabase);
        this.mapTab.construct();
        this.settingsTab = new SettingsTab(this.componentFactory, "secondary");
        this.cargoSystemPanel = new CargoSystemPanel(this.componentFactory);
        this.spacecraftTab = new SpacecraftTab(this.componentFactory);
        String introText = String.format(factory.translate("game_intro_helptext"), contextAction.name, changeTargetAction.name);
        String dockingText = factory.translate("game_docking_helptext", contextAction.name, changeTargetAction.name);
        String miningText = factory.translate("game_mining_helptext", changeTargetAction.name, toggleDrillAction.name);
        this.helpTab = new Wiki(factory);
        this.helpTab.setEntries(new Wiki.WikiEntry[]{new Wiki.WikiEntry(factory.translate("game_intro_helptext_header"), introText), new Wiki.WikiEntry(factory.translate("game_controls_helptext_header"), factory.translate("game_controls_helptext")), new Wiki.WikiEntry(factory.translate("game_sector_helptext_header"), factory.translate("game_sector_helptext")), new Wiki.WikiEntry(factory.translate("game_navigation_helptext_header"), factory.translate("game_navigation_helptext")), new Wiki.WikiEntry(factory.translate("game_mining_helptext_header"), miningText), new Wiki.WikiEntry(factory.translate("game_docking_helptext_header"), dockingText)});
        this.stationTab = new StationTab(factory);
        this.helpTab.setPreferredRows(20);
        this.helpTab.setDisplayHeight(500, 200, 500, 500);
        this.settingsTab.getMultiFormContainer().getFormController().addListener(new DefaultFormListener(){

            @Override
            public void onFormSubmit(AbstractForm form) {
                if (form == null) {
                    return;
                }
                if (form instanceof GameSettingsPanel) {
                    GameSettingsPanel gameSettingsPanel = (GameSettingsPanel)form;
                    gameSettingsPanel.applyValuesTo(AstraXApp.astraX.getApplicationSettings().generalSettings);
                    AstraXApp.astraX.applyGameSettings(AstraXApp.astraX.getApplicationSettings());
                } else if (form instanceof InputControlsForm) {
                    InputControlsForm inputControlsForm = (InputControlsForm)form;
                    KeyMappingSettings keyMappingSettings = new KeyMappingSettings();
                    inputControlsForm.applyValuesTo(keyMappingSettings);
                    AstraXApp.astraX.getApplicationSettings().keyMappingSettings.merge(keyMappingSettings);
                    AstraXApp.astraX.applyKeyMappingsToScreen(AstraXApp.astraX.getScreen(SpaceScreen.class));
                } else if (form instanceof SkinSettingsForm) {
                    SkinSettingsForm skinSettingsForm = (SkinSettingsForm)form;
                    skinSettingsForm.applyValuesTo(AstraXApp.astraX.getApplicationSettings().skinSettings);
                }
                AstraXApp.astraX.saveApplicationData(AstraXApp.astraX.getApplicationSettings());
            }

            @Override
            public void onFormReset(AbstractForm form) {
                if (form == null) {
                    return;
                }
                form.resetForm();
            }
        });
        this.mainMenuButton = this.addTabWithTextButton(this.getTranslation("game_menu_main"), "primary-tab", this.mainMenuTab);
        this.mapButton = this.addTabWithTextButton(this.getTranslation("game_menu_map"), "primary-tab", this.mapTab);
        this.spacecraftButton = this.addTabWithTextButton("Spacecraft", "primary-tab", this.spacecraftTab);
        this.cargoButton = this.addTabWithTextButton(this.getTranslation("game_menu_inventory"), "primary-tab", this.cargoSystemPanel);
        this.stationButton = this.addTabWithTextButton(this.getTranslation("game_menu_station"), "primary-tab", this.stationTab);
        this.settingsButton = this.addTabWithIconButton("secondary-48x48", "icon_inline_cog", this.settingsTab);
        this.helpButton = this.addTabWithIconButton("secondary-48x48", "icon_inline_questionmark", this.helpTab);
        this.primaryButtonGroup.addValue(this.mainMenuButton);
        this.primaryButtonGroup.addValue(this.mapButton);
        this.primaryButtonGroup.addValue(this.spacecraftButton);
        this.primaryButtonGroup.addValue(this.cargoButton);
        this.primaryButtonGroup.addValue(this.stationButton);
        this.primaryButtonGroup.addValueCentered(this.settingsButton);
        this.primaryButtonGroup.addValueCentered(this.helpButton);
        this.primaryButtonGroup.pack();
        this.mainMenuButton.addListener(this.clickListener);
        this.mapButton.addListener(this.clickListener);
        this.spacecraftButton.addListener(this.clickListener);
        this.cargoButton.addListener(this.clickListener);
        this.stationButton.addListener(this.clickListener);
        this.settingsButton.addListener(this.clickListener);
        this.helpButton.addListener(this.clickListener);
        this.setSize(Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
    }

    private void updateSecondaryMenu() {
        if (this.getStackController().getCurrentContent() instanceof GameMenuTab) {
            this.updateSecondaryButtons((GameMenuTab)((Object)this.getStackController().getCurrentContent()));
        } else {
            this.updateSecondaryButtons(null);
        }
    }

    private void updateSecondaryButtons(GameMenuTab gameMenuTab) {
        this.secondaryButtonGroup.clearChildren();
        if (gameMenuTab == null) {
            return;
        }
        int i2 = 0;
        for (Button button : gameMenuTab.getControlButtons()) {
            ((Actor)((Object)button)).addAction(Actions.delay((float)i2 / 10.0f, Tweening.getRumbleX(0.05f, 3.0f)));
            this.secondaryButtonGroup.addValueCentered((Actor)((Object)button));
            ++i2;
        }
    }

    @Override
    public void construct() {
        this.clear();
        if (this.background != null) {
            this.addActor(this.background);
            this.background.toBack();
        }
        this.helpTab.construct();
        this.contentStack.pack();
        this.add(this.primaryButtonGroup).fill().left().top().padBottom(5.0f).row();
        this.add(this.secondaryButtonGroup).minHeight(48.0f).fill().left().top().pad(5.0f).row();
        this.add(this.contentStack).top().size(Gdx.graphics.getWidth() - 16, (float)Gdx.graphics.getHeight() - this.mainMenuButton.getHeight() - 85.0f).fillX();
        this.stationButton.setDisabled(true);
        this.stackController.show(0);
    }

    public void updateCargo(CargoSystem cargoSystem) {
        this.cargoSystemPanel.update(cargoSystem);
    }

    public void setGalaxy(Galaxy galaxy) {
        this.mapTab.setGalaxy(galaxy);
        this.contentStack.pack();
    }

    public void setSectorCoordinates(int sectorX, int sectorY) {
        this.mapTab.updatePosition(sectorX, sectorY);
    }

    public void showTab(Class tabType) {
        this.stackController.show(tabType);
        this.updateSecondaryMenu();
        this.updateCheckedButton();
    }

    public void showNextTab() {
        this.stackController.next();
        this.updateSecondaryMenu();
        this.updateCheckedButton();
    }

    public void showPreviousTab() {
        this.stackController.previous();
        this.updateSecondaryMenu();
        this.updateCheckedButton();
    }

    private void updateCheckedButton() {
        int selected = this.stackController.getCurrentIndex();
        int current = 0;
        for (Button button : this.tabButtonGroup.getButtons()) {
            button.setChecked(current == selected);
            ++current;
        }
    }

    public SimplePanel getSecondaryButtonGroup() {
        return this.secondaryButtonGroup;
    }

    public AstraXTextButton getMainMenuButton() {
        return this.mainMenuButton;
    }

    public AstraXTextButton getMapButton() {
        return this.mapButton;
    }

    public AstraXTextButton getCargoButton() {
        return this.cargoButton;
    }

    public AstraXTextButton getStationButton() {
        return this.stationButton;
    }

    public AstraXButton getSettingsButton() {
        return this.settingsButton;
    }

    public AstraXButton getHelpButton() {
        return this.helpButton;
    }

    public CargoSystemPanel getCargoSystemPanel() {
        return this.cargoSystemPanel;
    }

    public SpacecraftTab getSpacecraftTab() {
        return this.spacecraftTab;
    }

    public StationTab getStationTab() {
        return this.stationTab;
    }

    public CargoSystemPanel getCargoBayPanel() {
        return this.cargoSystemPanel;
    }

    public MapTab getMapTab() {
        return this.mapTab;
    }

    public SettingsTab getSettingsTab() {
        return this.settingsTab;
    }

    public StarMap getStarMapTab2() {
        return null;
    }

    public Wiki getHelpTab() {
        return this.helpTab;
    }

    public static interface GameMenuTab {
        public List<Button> getControlButtons();
    }
}

