/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.game.menu.map.bookmarks;

import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.targeting.NavigationBookmark;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.buttons.AstraXButton;
import com.neutronio.astrax.ui.commons.buttons.CompositeButton;
import com.neutronio.astrax.ui.commons.buttons.StaticIcon;
import com.neutronio.astrax.ui.commons.text.AstraXLabel;

public class BookmarkButton
extends CompositeButton {
    private AstraXLabel nameValue;
    private StaticIcon icon;
    private AstraXButton editButton;
    private AstraXButton removeButton;
    private BookmarkButtonListener bookmarkButtonListener;

    public BookmarkButton(ComponentFactory factory) {
        super(factory);
        this.nameValue = new AstraXLabel(this.componentFactory, "", "header2", null);
        this.nameValue.setTouchable(Touchable.disabled);
        this.nameValue.setEllipsis(true);
        this.icon = new StaticIcon(this.componentFactory.getSkin(), "secondary-32x32");
        this.icon.setTouchable(Touchable.disabled);
        this.editButton = new AstraXButton(this.componentFactory, "icon_inline_edit", "primary");
        this.editButton.setCanCheck(false);
        this.editButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                super.clicked(event, x, y);
                if (BookmarkButton.this.editButton.isDisabled()) {
                    return;
                }
                event.setBubbles(false);
                event.stop();
                if (BookmarkButton.this.getListener() != null) {
                    BookmarkButton.this.getListener().onEditButtonClicked((NavigationBookmark)BookmarkButton.this.getUserObject());
                }
            }
        });
        this.removeButton = new AstraXButton(this.componentFactory, "icon_inline_trash", "control-red");
        this.removeButton.setCanCheck(false);
        this.removeButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                super.clicked(event, x, y);
                if (BookmarkButton.this.removeButton.isDisabled()) {
                    return;
                }
                event.setBubbles(false);
                event.stop();
                if (BookmarkButton.this.getListener() != null) {
                    BookmarkButton.this.getListener().onDeleteButtonClicked((NavigationBookmark)BookmarkButton.this.getUserObject());
                }
            }
        });
        this.addValue(this.removeButton).size(32.0f, 32.0f).padRight(5.0f).center();
        this.addValue(this.editButton).size(32.0f, 32.0f).padRight(20.0f).center();
        this.addValue(this.icon).size(32.0f, 32.0f).center();
        this.addValue(this.nameValue).maxWidth(150.0f).center();
        this.pack();
        this.centerBackground();
    }

    public BookmarkButtonListener getListener() {
        return this.bookmarkButtonListener;
    }

    public void setListener(BookmarkButtonListener bookmarkButtonListener) {
        this.bookmarkButtonListener = bookmarkButtonListener;
    }

    public AstraXButton getEditButton() {
        return this.editButton;
    }

    public AstraXButton getRemoveButton() {
        return this.removeButton;
    }

    public void update(NavigationBookmark bookmark) {
        if (bookmark != null) {
            this.nameValue.setText(bookmark.name);
            this.icon.setInlineIcon(bookmark.icon);
        } else {
            this.nameValue.setText("");
            this.icon.setInlineIcon((Drawable)null);
        }
    }

    @Override
    public void setDisabled(boolean disabled) {
        this.editButton.setDisabled(disabled);
        this.removeButton.setDisabled(disabled);
        super.setDisabled(disabled);
    }

    public static interface BookmarkButtonListener {
        public void onDeleteButtonClicked(NavigationBookmark var1);

        public void onEditButtonClicked(NavigationBookmark var1);
    }
}

