/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.game.menu.map.bookmarks;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.targeting.NavigationBookmark;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.forms.AbstractForm;
import com.neutronio.astrax.ui.commons.forms.Form;
import com.neutronio.astrax.ui.commons.forms.ValidationResult;
import com.neutronio.astrax.ui.commons.text.AstraXLabel;
import com.neutronio.astrax.ui.commons.widgets.IconPicker;
import com.neutronio.astrax.ui.commons.widgets.RGBSlider;

public class EditBookmarkPanel
extends AbstractForm {
    private TextField nameTextField;
    private IconPicker iconSelector;
    private RGBSlider RGBSlider;
    private NavigationBookmark oldBookmark;

    public EditBookmarkPanel(ComponentFactory componentFactory, String style, String backgroundStyle) {
        super(componentFactory, style, backgroundStyle);
        this.nameTextField = new TextField("", componentFactory.getSkin());
        this.nameTextField.removeListener(this.nameTextField.getDefaultInputListener());
        this.nameTextField.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                super.clicked(event, x, y);
                event.setBubbles(false);
            }
        });
        this.nameTextField.addListener(this.nameTextField.getDefaultInputListener());
        this.iconSelector = new IconPicker(componentFactory);
        this.iconSelector.setIconsPerRow(10);
        this.iconSelector.setIcons("icon_inline_bookmark", "icon_inline_camera", "icon_inline_cog", "icon_inline_coins", "icon_inline_dice", "icon_inline_discover", "icon_inline_pin", "icon_inline_edit", "icon_inline_erase", "icon_inline_user", "icon_inline_ship", "icon_inline_fuel", "icon_inline_home", "icon_inline_pickaxe", "icon_inline_research", "icon_inline_info", "icon_inline_radiation", "icon_inline_trash", "icon_inline_toxic", "icon_inline_warning", "icon_inline_weight", "icon_inline_x", "icon_inline_success", "icon_inline_galaxy", "icon_inline_orbit", "icon_vessel_large", "icon_vessel_medium", "icon_vessel_small", "icon_inline_target_asteroid", "icon_inline_target_dwarf", "icon_inline_target_solid", "icon_inline_target_gaseous", "icon_inline_target_oceanic", "icon_inline_target_moon", "icon_inline_target_pulsar", "icon_inline_target_star", "icon_inline_target_volcanic");
        this.iconSelector.setSelectedIcon("icon_inline_ship");
        this.RGBSlider = new RGBSlider(componentFactory);
        Color color = Color.WHITE.cpy();
        this.RGBSlider.setPickedColor(color);
        this.iconSelector.setIconColor(color);
        this.RGBSlider.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                EditBookmarkPanel.this.iconSelector.setIconColor(EditBookmarkPanel.this.RGBSlider.getPickedColor());
            }
        });
        AstraXLabel nameLabel = this.getLabel("Name");
        nameLabel.setAlignment(2, 8);
        this.addValue(nameLabel).top();
        this.addValue(this.nameTextField);
        this.row();
        AstraXLabel iconLabel = this.getLabel("Icon");
        iconLabel.setAlignment(2, 8);
        this.addValue(iconLabel).top();
        this.addValue(this.iconSelector);
        this.row();
        AstraXLabel colorLabel = this.getLabel("Color");
        colorLabel.setAlignment(2, 8);
        this.addValue(colorLabel).top();
        this.addValue(this.RGBSlider);
        this.pack();
    }

    public void update(NavigationBookmark navigationBookmark) {
        this.nameTextField.setText(navigationBookmark.name);
        this.iconSelector.setSelectedIcon(navigationBookmark.icon);
        this.RGBSlider.setPickedColor(navigationBookmark.color.cpy());
        this.oldBookmark = navigationBookmark;
    }

    public void storeInto(NavigationBookmark navigationBookmark) {
        navigationBookmark.name = this.nameTextField.getText();
        navigationBookmark.icon = this.iconSelector.getSelectedDrawableName();
        navigationBookmark.color = this.RGBSlider.getPickedColor().cpy();
    }

    @Override
    public ValidationResult validateForm(ValidationResult result) {
        if (this.nameTextField.getText().isEmpty()) {
            result.status(Form.ValidationStatus.INVALID);
            result.addMessage("Name can't be empty!", this.nameTextField);
        }
        return result;
    }

    @Override
    public void resetForm() {
        if (this.oldBookmark != null) {
            this.update(this.oldBookmark);
        }
    }

    @Override
    public void resetValues() {
    }
}

