/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.game.menu.map.bookmarks;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.targeting.NavigationBookmark;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.forms.AbstractForm;
import com.neutronio.astrax.ui.commons.forms.DefaultFormListener;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;
import com.neutronio.astrax.ui.commons.widgets.Modal;
import com.neutronio.astrax.ui.commons.widgets.PaginatorComponent;
import com.neutronio.astrax.ui.editor.Palette;
import com.neutronio.astrax.ui.game.menu.map.bookmarks.BookmarkButton;
import com.neutronio.astrax.ui.game.menu.map.bookmarks.EditBookmarkFormContainer;
import java.util.List;
import java.util.Map;

public class ManageBookmarksPanel
extends SimplePanel
implements BookmarkButton.BookmarkButtonListener {
    private static int DEFAULT_COLUMNS = 2;
    private Palette<BookmarkButton, NavigationBookmark> bookmarks;
    private PaginatorComponent paginatorComponent;
    private EditBookmarkFormContainer editBookmarkFormContainer;
    private Modal<EditBookmarkFormContainer> editBookmarkPanelModal;
    private ManageBookmarksListener listener;
    private NavigationBookmark editingBookmark;

    public ManageBookmarksPanel(ComponentFactory componentFactory) {
        super(componentFactory, "default", null);
        this.bookmarks = new Palette(componentFactory);
        this.bookmarks.top();
        int bookmarkWidth = 356;
        int bookmarkHeight = 77;
        this.bookmarks.setColumns(Gdx.graphics.getWidth() / (int)((float)bookmarkWidth * 1.2f));
        this.bookmarks.setIconCount((Gdx.graphics.getHeight() - 300) / (int)((double)bookmarkHeight * 1.2) * this.bookmarks.getColumns());
        this.bookmarks.setButtonProducer(new Palette.ButtonUpdater<BookmarkButton, NavigationBookmark>(){

            @Override
            public BookmarkButton createButton(ComponentFactory componentFactory, String style) {
                BookmarkButton bookmarkButton = new BookmarkButton(componentFactory);
                bookmarkButton.setListener(ManageBookmarksPanel.this);
                bookmarkButton.setDisabled(true);
                return bookmarkButton;
            }

            @Override
            public void updateButton(BookmarkButton button, NavigationBookmark bookmark) {
                button.update(bookmark);
                button.setUserObject(bookmark);
                button.setChecked(bookmark.isTracked);
                button.setDisabled(false);
            }

            @Override
            public void resetButton(BookmarkButton button) {
                button.update(null);
                button.setUserObject(null);
                button.setChecked(false);
                button.setDisabled(true);
            }
        });
        this.bookmarks.setButtonGroup(null);
        this.bookmarks.fillWithButtons(null);
        this.bookmarks.setListener(new Palette.PaletteListener<NavigationBookmark>(){

            @Override
            public void onSelectedChanged(NavigationBookmark selectedItem) {
                if (ManageBookmarksPanel.this.getListener() != null) {
                    ManageBookmarksPanel.this.getListener().onBookmarkTracked(selectedItem);
                }
            }
        });
        this.paginatorComponent = new PaginatorComponent(componentFactory);
        this.paginatorComponent.setPaginator(this.bookmarks);
        this.editBookmarkFormContainer = new EditBookmarkFormContainer(componentFactory);
        this.editBookmarkPanelModal = new Modal<EditBookmarkFormContainer>(componentFactory, this.editBookmarkFormContainer);
        this.editBookmarkPanelModal.setHeaderText("Edit Bookmark");
        this.editBookmarkPanelModal.setHeaderIcon("icon_inline_edit");
        this.editBookmarkPanelModal.pack();
        this.editBookmarkFormContainer.getFormController().addListener(new DefaultFormListener(){

            @Override
            public void onFormSubmit(AbstractForm form) {
                super.onFormSubmit(form);
                ManageBookmarksPanel.this.editBookmarkFormContainer.getEditBookmarkPanel().storeInto(ManageBookmarksPanel.this.editingBookmark);
                if (ManageBookmarksPanel.this.listener != null) {
                    ManageBookmarksPanel.this.listener.onBookmarkModified(ManageBookmarksPanel.this.editingBookmark);
                }
            }

            @Override
            public void onFormReset(AbstractForm form) {
                super.onFormReset(form);
                ManageBookmarksPanel.this.editBookmarkFormContainer.getEditBookmarkPanel().resetForm();
            }

            @Override
            public void onFormCancel(AbstractForm form) {
                super.onFormCancel(form);
                ManageBookmarksPanel.this.editBookmarkPanelModal.hide();
            }
        });
        Table bookmarkTable = new Table();
        bookmarkTable.add(this.bookmarks).top();
        bookmarkTable.row();
        bookmarkTable.add(this.paginatorComponent).padTop(15.0f).top();
        bookmarkTable.pack();
        this.addValue(bookmarkTable).top();
        this.pack();
    }

    public ManageBookmarksListener getListener() {
        return this.listener;
    }

    public void setListener(ManageBookmarksListener listener) {
        this.listener = listener;
    }

    public void setBookmarks(Map<String, NavigationBookmark> bookmarks) {
        this.bookmarks.setItems(bookmarks.values());
        this.bookmarks.updateToContent();
        this.pack();
    }

    public void setBookmarks(List<NavigationBookmark> bookmarks) {
        this.bookmarks.setItems(bookmarks);
        this.bookmarks.updateToContent();
        this.pack();
    }

    public void updateToContent() {
        this.bookmarks.updateToContent();
        this.pack();
    }

    public void addBookmark(NavigationBookmark bookmarks) {
        this.bookmarks.addItem(bookmarks);
        this.bookmarks.updateToContent();
        this.pack();
    }

    public void removeBookmark(NavigationBookmark bookmarks) {
        this.bookmarks.removeItem(bookmarks);
        this.bookmarks.updateToContent();
        this.pack();
    }

    @Override
    public void onDeleteButtonClicked(NavigationBookmark bookmark) {
        this.removeBookmark(bookmark);
        if (this.getListener() != null) {
            this.getListener().onBookmarkRemoved(bookmark);
        }
    }

    @Override
    public void onEditButtonClicked(NavigationBookmark bookmark) {
        this.editingBookmark = bookmark;
        if (bookmark != null) {
            this.editBookmarkFormContainer.getEditBookmarkPanel().update(bookmark);
            if (!this.editBookmarkPanelModal.hasParent()) {
                this.getStage().addActor(this.editBookmarkPanelModal);
            }
            this.editBookmarkPanelModal.toFront();
            this.editBookmarkPanelModal.show();
        }
    }

    public static interface ManageBookmarksListener {
        public void onBookmarkRemoved(NavigationBookmark var1);

        public void onBookmarkModified(NavigationBookmark var1);

        public void onBookmarkTracked(NavigationBookmark var1);
    }
}

