/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.game.menu.map.galaxy;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.datapack.game.world.SatelliteTarget;
import com.neutronio.astrax.app.datapack.game.world.galaxy.Galaxy;
import com.neutronio.astrax.app.datapack.game.world.galaxy.GalaxyRegion;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.Satellite;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.mining.MiningSystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem.StarSystemHeader;
import com.neutronio.astrax.app.screen.SpaceScreen;
import com.neutronio.astrax.io.sql.GalaxyRegionDAO;
import com.neutronio.astrax.io.sql.GameDatabase;
import com.neutronio.astrax.io.sql.StarSystemHeaderDAO;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.buttons.AstraXTextButton;
import com.neutronio.astrax.ui.commons.buttons.Checkbox;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;
import com.neutronio.astrax.ui.commons.widgets.ScrollContainer;
import com.neutronio.astrax.ui.commons.widgets.ZoomButtons;
import com.neutronio.astrax.ui.game.menu.map.galaxy.GalaxyMapCanvas;
import com.neutronio.astrax.ui.game.menu.map.starmap.detail.SectorDetailPanel;
import com.neutronio.astrax.util.Vector2i;
import java.sql.SQLException;

public class GalaxyMap
extends SimplePanel {
    private Galaxy galaxy;
    private ScrollContainer container;
    private GalaxyMapCanvas galaxyMapCanvas;
    private SectorDetailPanel sectorDetailPanel;
    private ZoomButtons zoomButtons;
    private AstraXTextButton jumpDriveButton;
    private Checkbox showGrid;
    private SimplePanel leftPanel;
    private SimplePanel rightPanel;
    private StarSystemHeaderDAO starSystemHeaderDAO;
    private GalaxyRegionDAO galaxyRegionDAO;

    public GalaxyMap(ComponentFactory componentFactory, GameDatabase gameDatabase) {
        super(componentFactory);
        this.starSystemHeaderDAO = new StarSystemHeaderDAO(gameDatabase);
        this.galaxyRegionDAO = new GalaxyRegionDAO(gameDatabase);
        this.galaxyMapCanvas = new GalaxyMapCanvas(componentFactory);
        this.galaxyMapCanvas.setStars(componentFactory.getSkin().getRegion("stars_0"), componentFactory.getSkin().getRegion("stars_1"), componentFactory.getSkin().getRegion("stars_2"));
        this.sectorDetailPanel = new SectorDetailPanel(componentFactory);
        this.sectorDetailPanel.construct();
        this.galaxyMapCanvas.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (event.isHandled() || GalaxyMap.this.galaxyMapCanvas.getSelectedTile() == null) {
                    return;
                }
                Vector2i selectedTile = GalaxyMap.this.galaxyMapCanvas.getSelectedTile();
                try {
                    StarSystemHeader starSystemHeader;
                    GalaxyRegion galaxyRegion = GalaxyMap.this.galaxy.getCachedRegion(selectedTile.x, selectedTile.y);
                    if (galaxyRegion == null && (galaxyRegion = GalaxyMap.this.galaxyRegionDAO.getByLocation(selectedTile.x, selectedTile.y)) != null) {
                        GalaxyMap.this.galaxy.addRegionToCache(galaxyRegion, selectedTile.x, selectedTile.y);
                    }
                    if ((starSystemHeader = GalaxyMap.this.galaxy.getStarSystemHeader(selectedTile.x, selectedTile.y)) == null && (starSystemHeader = GalaxyMap.this.starSystemHeaderDAO.getByLocation(selectedTile.x, selectedTile.y)) != null) {
                        GalaxyMap.this.galaxy.addStarSystemHeader(starSystemHeader, selectedTile.x, selectedTile.y);
                    }
                    if (starSystemHeader != null) {
                        GalaxyMap.this.sectorDetailPanel.update(starSystemHeader.name, selectedTile, starSystemHeader.starType.name(), galaxyRegion != null ? galaxyRegion.getRegionName() : GalaxyMap.this.getTranslation("game_map_none"), starSystemHeader.discovered);
                    } else {
                        String unknown = GalaxyMap.this.getTranslation("game_map_unknown");
                        GalaxyMap.this.sectorDetailPanel.update(unknown, selectedTile, unknown, galaxyRegion != null ? galaxyRegion.getRegionName() : GalaxyMap.this.getTranslation("game_map_none"), 0.0f);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                event.handle();
            }
        });
        this.container = new ScrollContainer<GalaxyMapCanvas>(this.galaxyMapCanvas);
        this.zoomButtons = new ZoomButtons(componentFactory);
        this.zoomButtons.construct();
        this.zoomButtons.setZoomable(this.container.getZoomer());
        this.showGrid = new Checkbox(componentFactory, "checkbox");
        this.showGrid.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (GalaxyMap.this.showGrid.isChecked()) {
                    GalaxyMap.this.galaxyMapCanvas.setShowGrid(true);
                } else {
                    GalaxyMap.this.galaxyMapCanvas.setShowGrid(false);
                }
            }
        });
        this.jumpDriveButton = new AstraXTextButton(componentFactory, "secondary");
        this.jumpDriveButton.setText(this.getTranslation("game_map_use_jumpdrive"));
        this.jumpDriveButton.setCanCheck(false);
        this.jumpDriveButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                MiningSystem system;
                super.clicked(event, x, y);
                SpaceScreen screen = AstraXApp.astraX.getScreen(SpaceScreen.class);
                SatelliteTarget playerTarget = screen.getAstraxGame().getLocalPlayer().getPlayerTarget();
                if (((Satellite)playerTarget.getModel()).hasSystem(MiningSystem.class) && (system = ((Satellite)playerTarget.getModel()).getSystem(MiningSystem.class)).getMiningDrills().get(0).isRunning()) {
                    AstraXApp.astraX.showErrorAlert("Please turn off the mining drill before using the jump drive!");
                    return;
                }
                Vector2i selectedLocation = GalaxyMap.this.galaxyMapCanvas.getSelectedLocation();
                if (selectedLocation == null) {
                    return;
                }
                Vector2 globalLocation = screen.getAstraxGame().getWorld().sectorToGlobalCoordinates(selectedLocation.x - screen.getAstraxGame().getWorld().getGalaxy().getWidth() / 2, selectedLocation.y - screen.getAstraxGame().getWorld().getGalaxy().getHeight() / 2, 0.0f, 0.0f);
                screen.getAstraxGame().getWorld().teleportToPosition(screen.getAstraxGame().getLocalPlayer().getPlayerTarget(), globalLocation.x, globalLocation.y);
            }
        });
        SimplePanel controlPanel = new SimplePanel(componentFactory);
        controlPanel.addValue(this.zoomButtons);
        controlPanel.getCell(this.zoomButtons).padRight(30.0f);
        controlPanel.addLabel("Grid:");
        controlPanel.addValueCentered(this.showGrid);
        controlPanel.add().expand();
        controlPanel.pack();
        controlPanel.align(1);
        this.leftPanel = new SimplePanel(componentFactory);
        this.leftPanel.addValue(controlPanel);
        this.leftPanel.getCell(controlPanel).left();
        this.leftPanel.row();
        this.leftPanel.add(this.container).pad(10.0f).size(500.0f, 500.0f);
        this.container.pack();
        this.leftPanel.pack();
        this.rightPanel = new SimplePanel(componentFactory);
        this.rightPanel.addValue(this.sectorDetailPanel);
        this.rightPanel.row();
        this.rightPanel.addValueCentered(this.jumpDriveButton);
        this.rightPanel.pack();
        this.addValue(this.leftPanel, 1);
        this.addValue(this.rightPanel, 1);
        this.pack();
    }

    public void disableJumpDriveButton() {
        this.jumpDriveButton.setDisabled(true);
    }

    public void enableJumpDriveButton() {
        this.jumpDriveButton.setDisabled(false);
    }

    public GalaxyMapCanvas getGalaxyMapCanvas() {
        return this.galaxyMapCanvas;
    }

    public void setGalaxy(Galaxy galaxy) {
        this.galaxy = galaxy;
        this.galaxyMapCanvas.setGalaxy(galaxy);
        this.leftPanel.getCell(this.container).size(500.0f, 500.0f).pad(20.0f);
        this.leftPanel.pack();
        this.container.pack();
    }

    public void setCurrentCoordinates(int worldX, int worldY) {
        this.galaxyMapCanvas.setCurrentLocation(worldX, worldY);
    }
}

