/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.game.menu.map.galaxy;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.neutronio.astrax.app.datapack.game.world.galaxy.Galaxy;
import com.neutronio.astrax.app.datapack.game.world.galaxy.GalaxyRegion;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.GridComponent;
import com.neutronio.astrax.util.MathUtil;
import com.neutronio.astrax.util.Vector2i;
import com.neutronio.astrax.util.collections.Grid;
import java.util.ArrayList;
import java.util.List;
import space.earlygrey.shapedrawer.ShapeDrawer;

public class GalaxyMapCanvas
extends GridComponent<GalaxyTile> {
    private TextureRegion[] stars;
    protected Vector2i currentLocation = null;
    protected Galaxy galaxy;

    public GalaxyMapCanvas(ComponentFactory componentFactory) {
        super(componentFactory);
    }

    public void setStars(TextureRegion ... stars) {
        this.stars = stars;
    }

    public void setGalaxy(Galaxy galaxy) {
        this.galaxy = galaxy;
        this.setSize(galaxy.getWidth() * this.tileSize, galaxy.getHeight() * this.tileSize);
        this.data = new Grid(galaxy.getWidth(), galaxy.getHeight());
        for (int x = 0; x < galaxy.getWidth(); ++x) {
            for (int y = 0; y < galaxy.getHeight(); ++y) {
                GalaxyRegion region = this.galaxy.getCachedRegion(x, y);
                Galaxy.SectorProperty sectorProperty = this.galaxy.getSectorPropertybyLocalCoordinates(x, y);
                GalaxyTile galaxyTile = new GalaxyTile(this.stars[MathUtil.getRandomInteger(this.stars.length)], sectorProperty.color, sectorProperty.density, !this.galaxy.isFreeForRegionCollision(x, y));
                this.data.place(x, y, galaxyTile);
                if (region == null) continue;
                galaxyTile.backgroundColor = region.getRegionColor();
            }
        }
    }

    public Galaxy getGalaxy() {
        return this.galaxy;
    }

    @Override
    protected void selectTile(int xTile, int yTile) {
        super.selectTile(xTile, yTile);
        if (this.selectedTile != null && this.data.isInBounds(xTile, yTile)) {
            ((GalaxyTile)this.data.get((int)this.selectedTile.x, (int)this.selectedTile.y)).iconBounce = 40.0f;
        }
    }

    public void setCurrentLocation(int worldX, int worldY) {
        if (this.currentLocation == null) {
            this.currentLocation = new Vector2i();
        }
        this.currentLocation.set(worldX + this.galaxy.getWidth() / 2, worldY + this.galaxy.getHeight() / 2);
        this.markSystemAsVisited(this.currentLocation.x, this.currentLocation.y);
    }

    public Vector2i getSelectedLocation() {
        return this.selectedTile != null ? this.selectedTile.copy() : null;
    }

    public void markSystemAsVisited(int localX, int localY) {
        ((GalaxyTile)this.data.get(localX, localY)).visited = true;
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        super.draw(batch, parentAlpha);
        this.drawPregeneratedSystems(batch, parentAlpha);
        ShapeDrawer shapeDrawer = this.componentFactory.getUiRenderContext().getShapeDrawer();
        if (this.currentLocation != null) {
            this.bounce = (int)Interpolation.sine.apply(0.0f, 15.0f, this.time);
            shapeDrawer.setColor(this.style.currentLocationColor.r, this.style.currentLocationColor.g, this.style.currentLocationColor.b, MathUtils.lerp(0.1f, 1.0f, Interpolation.sine.apply(this.time)));
            shapeDrawer.setDefaultLineWidth(6.0f);
            shapeDrawer.rectangle(this.getX() + (float)(this.currentLocation.x * this.tileSize) * this.getScaleX(), this.getY() + (float)(this.currentLocation.y * this.tileSize) * this.getScaleY(), (float)this.tileSize * this.getScaleX(), (float)this.tileSize * this.getScaleY());
            shapeDrawer.rectangle(this.getX() + (float)(this.currentLocation.x * this.tileSize) * this.getScaleX() - (float)this.bounce / 2.0f, this.getY() + (float)(this.currentLocation.y * this.tileSize) * this.getScaleY() - (float)this.bounce / 2.0f, (float)this.tileSize * this.getScaleX() + (float)this.bounce, (float)this.tileSize * this.getScaleY() + (float)this.bounce);
            shapeDrawer.setDefaultLineWidth(1.0f);
        }
    }

    public void drawPregeneratedSystems(Batch batch, float parentAlpha) {
    }

    public void drawGalaxyRegions() {
    }

    public class GalaxyTile
    implements GridComponent.GridTile {
        public TextureRegion starsTexture;
        public Color backgroundColor;
        public TextureRegion icon;
        public Color iconColor;
        public float iconBounce;
        public float brightness;
        private boolean hasRegion;
        private boolean visited = false;

        public GalaxyTile(TextureRegion starsTexture, Color backgroundColor, float brightness, boolean hasRegion) {
            this.starsTexture = starsTexture;
            this.backgroundColor = backgroundColor;
            this.hasRegion = hasRegion;
            this.brightness = brightness;
        }

        @Override
        public void render(Batch batch, float x, float y, float originX, float originY, float width, float height, float parentAlpha) {
            if (this.visited) {
                GalaxyMapCanvas.this.componentFactory.getUiRenderContext().getShapeDrawer().setColor(this.backgroundColor.r, this.backgroundColor.g, this.backgroundColor.b, this.brightness);
            } else {
                GalaxyMapCanvas.this.componentFactory.getUiRenderContext().getShapeDrawer().setColor(this.backgroundColor.r, this.backgroundColor.g, this.backgroundColor.b, this.brightness * 0.2f);
            }
            GalaxyMapCanvas.this.componentFactory.getUiRenderContext().getShapeDrawer().filledRectangle(x, y, width, height);
            if (this.visited) {
                batch.setColor(1.0f, 1.0f, 1.0f, MathUtils.clamp(this.brightness * 1.3f, 0.0f, 1.0f));
            } else {
                batch.setColor(1.0f, 1.0f, 1.0f, this.brightness * 0.3f);
            }
            batch.draw(this.starsTexture, x, y, originX, originY, width, height, 1.0f, 1.0f, 0.0f);
            if (this.hasRegion) {
                GalaxyMapCanvas.this.componentFactory.getUiRenderContext().getShapeDrawer().setColor(Color.YELLOW.r, Color.YELLOW.g, Color.YELLOW.b, 0.3f * parentAlpha);
                GalaxyMapCanvas.this.componentFactory.getUiRenderContext().getShapeDrawer().filledRectangle(x, y, width, height);
            }
            if (this.icon != null) {
                this.iconBounce *= 0.9f;
                batch.setColor(this.iconColor);
                batch.draw(this.icon, x - this.iconBounce / 2.0f, y - this.iconBounce / 2.0f, originX, originY, width + this.iconBounce, height + this.iconBounce, 1.0f, 1.0f, 0.0f);
            }
        }
    }

    public class GalaxyRegionMarker {
        List<Vector2i> locations = new ArrayList<Vector2i>();
        Color color = null;

        public GalaxyRegionMarker(Color color) {
            this.color = color;
        }

        public void addLocation(Vector2i location) {
            this.locations.add(location);
        }
    }
}

