/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.game.menu.map.starmap;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.NinePatchDrawable;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.badlogic.gdx.scenes.scene2d.utils.TiledDrawable;
import com.neutronio.astrax.app.datapack.EntityID;
import com.neutronio.astrax.app.datapack.game.DiscoveryTarget;
import com.neutronio.astrax.app.datapack.game.world.SatelliteTarget;
import com.neutronio.astrax.app.datapack.game.world.galaxy.Sector;
import com.neutronio.astrax.app.datapack.game.world.galaxy.StarSystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.Satellite;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.targeting.DiscoveryDatabank;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.targeting.DiscoverySystem;
import com.neutronio.astrax.gfx.StarSystemGraphics;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.buttons.AstraXButton;
import com.neutronio.astrax.ui.commons.buttons.Button;
import com.neutronio.astrax.ui.commons.buttons.ButtonGroup;
import com.neutronio.astrax.ui.commons.widgets.Zoomer;
import com.neutronio.astrax.ui.game.OrbitRenderer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class StarMapCanvas
extends Group {
    private static Logger logger = Logger.getLogger(StarMapCanvas.class.getCanonicalName());
    private float xFocus;
    private float yFocus;
    private ComponentFactory componentFactory;
    private Drawable background;
    private Drawable backgroundFrame;
    private Zoomer zoomer = new Zoomer();
    private ButtonGroup buttonManager;
    private OrbitRenderer orbitRenderer;
    private DiscoveryTarget selfTarget;
    private float selfSensorRange;
    private TargetButton selfTargetButton;
    private DiscoveryDatabank selfDatabank;
    private Map<EntityID, TargetButton> targetButtons = new HashMap<EntityID, TargetButton>();
    private ClickListener planetButtonListener;
    private Sector<StarSystem> starSystem;

    private static String getStarMapIconStyle(DiscoveryTarget discoveryTarget) {
        if (discoveryTarget.discovery == null) {
            return "starmap-target-planet";
        }
        switch (discoveryTarget.discovery.classification) {
            case RUINS: 
            case WRECK: 
            case SPACECRAFT: {
                return "starmap-target-satellite";
            }
        }
        return "starmap-target-planet";
    }

    public StarMapCanvas(ClickListener targetButtonListener, ComponentFactory componentFactory) {
        this.componentFactory = componentFactory;
        this.planetButtonListener = targetButtonListener;
        this.orbitRenderer = new OrbitRenderer(componentFactory);
        Skin skin = componentFactory.getSkin();
        this.background = new TiledDrawable((TextureRegionDrawable)skin.getDrawable("pattern_grid"));
        this.backgroundFrame = new NinePatchDrawable(skin.getPatch("background_tech_deco_1"));
        this.buttonManager = new ButtonGroup();
        this.buttonManager.setMaxCheckCount(1);
        this.buttonManager.setMinCheckCount(0);
        this.buttonManager.setUncheckLast(true);
        this.setSize(500.0f, 500.0f);
    }

    public Button getSelectedButton() {
        return this.buttonManager.getChecked();
    }

    public void clearButtons() {
        logger.finest("Clearing Buttons...");
        for (TargetButton targetButton : this.targetButtons.values()) {
            targetButton.icon.remove();
        }
        this.buttonManager.clear();
        this.targetButtons.clear();
    }

    public OrbitRenderer getOrbitRenderer() {
        return this.orbitRenderer;
    }

    public void setSelf(DiscoveryTarget self) {
        this.selfTarget = self;
        this.selfDatabank = ((Satellite)((SatelliteTarget)self.target).getModel()).getSystem(DiscoverySystem.class).getDatabank();
        this.selfSensorRange = ((Satellite)((SatelliteTarget)self.target).getModel()).getSystem(DiscoverySystem.class).getProximitySensor().getMaxRange();
    }

    public void setStarSystem(Sector<StarSystem> starSystem) {
        this.starSystem = starSystem;
    }

    public Zoomer getZoomer() {
        return this.zoomer;
    }

    public void onStarSystemChanged() {
        this.clearButtons();
        this.addSelfButton(this.selfTarget);
        this.synchronizeTargets(this.selfDatabank.getDiscoveries().values());
    }

    private void addSelfButton(DiscoveryTarget target) {
        this.selfTargetButton = this.addTarget(target);
        this.selfTargetButton.isMobile = true;
    }

    private void synchronizeTargets(Collection<DiscoveryTarget> discoveryTargets) {
        logger.finest("Synchronize Targets with DiscoveryDatabank content...");
        for (DiscoveryTarget discoveryTarget : discoveryTargets) {
            if (discoveryTarget.discovery == null) continue;
            this.addTarget(discoveryTarget);
        }
    }

    public TargetButton addTarget(DiscoveryTarget discoveryTarget) {
        TargetButton targetButton = this.targetButtons.get(discoveryTarget.target.getID());
        if (targetButton == null) {
            TargetButton newButton = new TargetButton(discoveryTarget);
            newButton.update(discoveryTarget);
            this.targetButtons.put(discoveryTarget.target.getID(), newButton);
            this.addActor(newButton.icon);
            return newButton;
        }
        targetButton.update(discoveryTarget);
        return targetButton;
    }

    public void refreshTargetIcon(EntityID entityID) {
        if (!this.targetButtons.containsKey(entityID)) {
            return;
        }
        TargetButton targetButton = this.targetButtons.get(entityID);
        targetButton.update(targetButton.target);
    }

    @Override
    public void act(float delta) {
        super.act(delta);
        this.zoomer.update(delta);
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        this.clipBegin();
        batch.setColor(1.0f, 1.0f, 1.0f, parentAlpha);
        this.backgroundFrame.draw(batch, this.getX(), this.getY(), this.getWidth(), this.getHeight());
        this.background.draw(batch, this.getX() + 15.0f, this.getY() + 15.0f, this.getWidth() - 30.0f, this.getHeight() - 30.0f);
        float centerX = this.getWidth() / 2.0f;
        float centerY = this.getHeight() / 2.0f;
        for (TargetButton target : this.targetButtons.values()) {
            target.updatePosition(this.zoomer.getScale());
        }
        this.componentFactory.getUiRenderContext().assertValid(batch);
        this.orbitRenderer.render(this.componentFactory.getUiRenderContext().getShapeDrawer(), this.selfDatabank, this.starSystem.getChunk().getSystemStructure(), this.getX() + centerX, this.getY() + centerY, this.zoomer.getScale(), parentAlpha);
        this.componentFactory.getUiRenderContext().getShapeDrawer().setColor(Color.CYAN.r, Color.CYAN.g, Color.CYAN.b, 0.4f);
        this.componentFactory.getUiRenderContext().getShapeDrawer().filledCircle(this.getX() + this.selfTargetButton.icon.getX() + this.selfTargetButton.icon.getWidth() / 2.0f, this.getY() + this.selfTargetButton.icon.getY() + this.selfTargetButton.icon.getHeight() / 2.0f, this.selfSensorRange * this.zoomer.getScale());
        super.draw(batch, parentAlpha);
        this.clipEnd();
    }

    public class TargetButton {
        public Image bookmark;
        public AstraXButton icon;
        public DiscoveryTarget target;
        public boolean isMobile = false;
        public Vector2 systemPos = new Vector2();

        public TargetButton(DiscoveryTarget target) {
            this.icon = this.createButton(target);
            this.icon.setVisible(false);
            this.target = target;
        }

        public void update(DiscoveryTarget discoveryTarget) {
            this.icon.setVisible(true);
            this.icon.setInlineIcon(StarMapCanvas.this.componentFactory.getSkin().getDrawable(discoveryTarget.getIcon()));
            if (discoveryTarget.bookmark != null) {
                if (this.bookmark != null) {
                    this.bookmark.remove();
                }
                this.bookmark = new Image(StarMapCanvas.this.componentFactory.getSkin(), "icon_round_over");
                this.bookmark.setTouchable(Touchable.disabled);
                this.icon.addActor(this.bookmark);
            } else if (this.bookmark != null) {
                this.bookmark.remove();
            }
        }

        private AstraXButton createButton(DiscoveryTarget newTarget) {
            AstraXButton button = this.getButtonForGraphics(StarMapCanvas.getStarMapIconStyle(newTarget));
            button.setProgrammaticChangeEvents(true);
            button.setUserObject(newTarget);
            StarMapCanvas.this.buttonManager.add(button);
            button.addListener(StarMapCanvas.this.planetButtonListener);
            return button;
        }

        private AstraXButton getButtonForGraphics(String buttonStyle) {
            return new AstraXButton(StarMapCanvas.this.componentFactory, "icon_inline_questionmark", buttonStyle);
        }

        public void updatePosition(float scale) {
            if (this.isMobile) {
                StarSystemGraphics graphics = ((StarSystem)StarMapCanvas.this.starSystem.getChunk()).getGraphics();
                this.systemPos.set(this.target.target.getWorldPositionX() - graphics.getX(), this.target.target.getWorldPositionY() - graphics.getY());
            } else {
                this.systemPos.set(0.0f, 0.0f);
                ((StarSystem)StarMapCanvas.this.starSystem.getChunk()).getLocalCoordinatesOfMember(this.target.target.getID(), this.systemPos);
            }
            this.icon.setPosition(StarMapCanvas.this.getWidth() / 2.0f + this.systemPos.x * scale - this.icon.getWidth() / 2.0f, StarMapCanvas.this.getHeight() / 2.0f + this.systemPos.y * scale - this.icon.getHeight() / 2.0f);
        }
    }
}

