/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.game.menu.map.starmap;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextTooltip;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.ButtonClickListener;
import com.neutronio.astrax.ui.commons.buttons.AstraXButton;
import com.neutronio.astrax.ui.commons.widgets.ZoomButtons;
import com.neutronio.astrax.ui.commons.widgets.Zoomer;
import com.neutronio.astrax.ui.game.menu.map.starmap.StarMapControlButtonsListener;

public class StarMapControlButtons
extends Table {
    private ZoomButtons zoomButtons;
    private AstraXButton resetFocusButton;
    private AstraXButton focusSelectedPlanetButton;
    private StarMapControlButtonsListener controlListener;

    public StarMapControlButtons(ComponentFactory factory, Zoomer zoomer, ButtonClickListener buttonSounds) {
        super(factory.getSkin());
        Skin skin = factory.getSkin();
        this.zoomButtons = new ZoomButtons(factory);
        this.zoomButtons.construct();
        this.zoomButtons.setZoomable(zoomer);
        this.resetFocusButton = new AstraXButton(factory, "icon_inline_home", "primary-no-check");
        this.resetFocusButton.setSize(32.0f, 32.0f);
        this.resetFocusButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                StarMapControlButtons.this.getControlListener().onFocusChangedToPlayer();
            }
        });
        this.resetFocusButton.addListener(buttonSounds);
        this.resetFocusButton.addListener(new TextTooltip("Center to Player", this.getSkin()));
        this.resetFocusButton.setCanCheck(false);
        this.focusSelectedPlanetButton = new AstraXButton(factory, "icon_inline_center", "primary-no-check");
        this.focusSelectedPlanetButton.setSize(32.0f, 32.0f);
        this.focusSelectedPlanetButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                StarMapControlButtons.this.getControlListener().onFocusChangedToCurrentTarget();
            }
        });
        this.focusSelectedPlanetButton.addListener(buttonSounds);
        this.focusSelectedPlanetButton.addListener(new TextTooltip("Center to selected Planet", this.getSkin()));
        this.focusSelectedPlanetButton.setCanCheck(false);
        this.add(this.zoomButtons).padLeft(5.0f);
        this.add().minSize(60.0f, 10.0f);
        this.add(this.resetFocusButton).pad(2.0f);
        this.add(this.focusSelectedPlanetButton).pad(2.0f);
        this.pack();
    }

    public StarMapControlButtonsListener getControlListener() {
        return this.controlListener;
    }

    public void setControlListener(StarMapControlButtonsListener controlListener) {
        this.controlListener = controlListener;
    }
}

