/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.game.menu.map.starmap.detail;

import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.datapack.game.mechanics.resources.Resource;
import com.neutronio.astrax.app.datapack.game.world.galaxy.asteroid.Asteroid;
import com.neutronio.astrax.app.repository.ResourceRepository;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;
import com.neutronio.astrax.ui.commons.text.AstraXLabel;
import com.neutronio.astrax.ui.commons.text.TextProgressbar;
import com.neutronio.astrax.util.StandardFormats;

public class AsteroidDetailPanel
extends SimplePanel {
    private AstraXLabel nameValue = this.getLabel("-");
    private AstraXLabel depositTypeValue = this.getLabel("-");
    private TextProgressbar resourcesLeft;
    private HorizontalGroup resourceIcons = new HorizontalGroup();

    public AsteroidDetailPanel(ComponentFactory componentFactory) {
        super(componentFactory, "detailpanel", null);
        this.resourceIcons.space(10.0f);
        this.resourcesLeft = new TextProgressbar(componentFactory);
        this.resourcesLeft.setBaseValue(1.0f);
        this.resourcesLeft.setUsePercent(true);
        this.resourcesLeft.setFormat(StandardFormats.PERCENT);
    }

    @Override
    public void construct() {
        this.clear();
        super.construct();
        this.addHeader("Asteroid", 2);
        this.row();
        this.addRow("Name", this.nameValue);
        this.row();
        this.addRow("Deposit", this.depositTypeValue);
        this.row();
        this.addRow("Resources", this.resourceIcons);
        this.row();
        this.addRow("Remaining", this.resourcesLeft);
    }

    public void update(Asteroid asteroid) {
        ResourceRepository resourceRepository = AstraXApp.astraX.getRepository(ResourceRepository.class);
        this.nameValue.setText(asteroid.getSettings().name);
        this.depositTypeValue.setText(asteroid.getSettings().resourceSettings.getName());
        this.resourceIcons.clear();
        for (int i2 = 0; i2 < asteroid.getSettings().resourceSettings.getResourceSettings().resources.size(); ++i2) {
            String resourceID = asteroid.getSettings().resourceSettings.getResourceSettings().resources.getItemAt(i2);
            Resource resource = (Resource)resourceRepository.find(resourceID);
            Image icon = new Image(this.componentFactory.getSkin().getDrawable(resource.icon));
            icon.addListener(this.componentFactory.getToolTip(resource.name));
            this.resourceIcons.addActor(icon);
        }
        this.resourcesLeft.setValue(asteroid.getResources().getRemainingDeposit());
        this.pack();
    }
}

