/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.game.menu.map.starmap.detail;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.neutronio.astrax.app.datapack.game.mechanics.discovery.DiscoveredStatus;
import com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem.Planet;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.IconLabel;
import com.neutronio.astrax.ui.commons.ProgressBar;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;
import com.neutronio.astrax.ui.commons.text.AstraXLabel;

public class CelestialBodyDetailPanel
extends SimplePanel {
    private AstraXLabel nameValue = this.getLabel("-");
    private AstraXLabel statusValue = this.getLabel("-");
    private IconLabel typeIconValue;
    private IconLabel subtypeValue;
    private ProgressBar discoveredBar;
    private String[] labels;
    private Actor[] values;

    public CelestialBodyDetailPanel(ComponentFactory componentFactory) {
        super(componentFactory, "detailpanel", "tab-inner");
        this.statusValue.setColor(DiscoveredStatus.DISCOVERED.getColor());
        this.typeIconValue = new IconLabel(componentFactory, "detail-inline", "label");
        this.typeIconValue.set("icon_inline_target_gaseous", "-");
        this.subtypeValue = new IconLabel(componentFactory, "detail-inline", "label");
        this.subtypeValue.set("icon_inline_questionmark", "-");
        this.discoveredBar = new ProgressBar(componentFactory);
        this.discoveredBar.setValue(45.0f);
        this.labels = new String[]{"Name", "Status", "Class", "Subclass", "Discovered"};
        this.values = new Actor[]{this.nameValue, this.statusValue, this.typeIconValue, this.subtypeValue, this.discoveredBar};
    }

    @Override
    public void construct() {
        this.clear();
        super.construct();
        for (int i2 = 0; i2 < this.values.length; ++i2) {
            this.addLabel(this.labels[i2]);
            this.addValue(this.values[i2]);
            this.row();
        }
    }

    public void setCelestialBody(Planet planet, float discoveredPercent, DiscoveredStatus status) {
        if (planet == null) {
            this.nameValue.setText("-");
            this.statusValue.setText("-");
            this.statusValue.setColor(Color.WHITE);
            this.typeIconValue.set("icon_inline_questionmark", "-");
            this.subtypeValue.set("icon_inline_questionmark", "-");
            this.discoveredBar.setValue(0.0f);
        } else {
            this.nameValue.setText(planet.getName());
            this.statusValue.setText(status.name());
            this.statusValue.setColor(status.getColor());
            this.typeIconValue.set(planet.getClassIcon(), planet.getClassName());
            this.subtypeValue.set(planet.getTypeIcon(), planet.getTypeName());
            this.discoveredBar.setValue(discoveredPercent / 100.0f);
        }
    }
}

