/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.game.menu.map.starmap.detail;

import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.datapack.game.mechanics.discovery.DiscoveredStatus;
import com.neutronio.astrax.app.datapack.game.world.galaxy.planet.PlanetTrait;
import com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem.Planet;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;
import com.neutronio.astrax.ui.game.menu.map.starmap.detail.CelestialBodyDetailPanel;
import com.neutronio.astrax.ui.game.menu.map.starmap.detail.TraitsPanel;
import java.util.List;

public class CelestialPanel
extends SimplePanel {
    private CelestialBodyDetailPanel celestialBodyDetailPanel;
    private TraitsPanel traitsPanel;

    public CelestialPanel(ComponentFactory componentFactory) {
        super(componentFactory, "detailpanel", null);
        this.addHeader("Planet", 2);
        this.row();
        this.celestialBodyDetailPanel = new CelestialBodyDetailPanel(componentFactory);
        this.celestialBodyDetailPanel.construct();
        this.add(this.celestialBodyDetailPanel).fill();
        this.row().padBottom(10.0f).padTop(10.0f);
        this.addHeader("Traits", 2);
        this.row();
        this.traitsPanel = new TraitsPanel(componentFactory);
        this.add(this.traitsPanel).fill();
        this.pack();
    }

    public void setPlanet(Planet planet, float discoveredPercent) {
        if (planet != null) {
            this.celestialBodyDetailPanel.setCelestialBody(planet, discoveredPercent, DiscoveredStatus.DISCOVERED);
            List<PlanetTrait> traits = AstraXApp.astraX.getRepositoryFactory().findResourcesByIDs(planet.getCustomPlanetSettings().traits);
            this.traitsPanel.setTraits(traits);
        } else {
            this.celestialBodyDetailPanel.setCelestialBody(planet, 0.0f, DiscoveredStatus.UNKNOWN);
            this.traitsPanel.setTraits(null);
        }
    }
}

