/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.game.menu.map.starmap.detail;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.neutronio.astrax.app.datapack.game.world.galaxy.Sector;
import com.neutronio.astrax.app.datapack.game.world.galaxy.StarSystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.StarSystemSettings;
import com.neutronio.astrax.gfx.entities.GraphicsContainer;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;
import com.neutronio.astrax.ui.commons.text.AstraXLabel;
import com.neutronio.astrax.ui.commons.text.TextProgressbar;
import com.neutronio.astrax.util.StandardFormats;
import com.neutronio.astrax.util.Vector2i;

public class SectorDetailPanel
extends SimplePanel {
    public GraphicsContainer starImage;
    public AstraXLabel nameValue = this.getLabel("n.A.");
    public AstraXLabel systemTypeValue;
    public AstraXLabel centralStarValue;
    public AstraXLabel regionValue;
    public AstraXLabel coordinatesValue = this.getLabel("n.A.");
    public TextProgressbar discoveredValue;
    private String[] labels;
    private Actor[] values;

    public SectorDetailPanel(ComponentFactory componentFactory) {
        super(componentFactory, "detailpanel", null);
        this.systemTypeValue = this.getLabel("n.A.");
        this.centralStarValue = this.getLabel("n.A.");
        this.regionValue = this.getLabel("n.A.");
        this.discoveredValue = new TextProgressbar(componentFactory);
        this.discoveredValue.setUsePercent(true);
        this.discoveredValue.setBaseValue(1.0f);
        this.discoveredValue.setFormat(StandardFormats.PERCENT);
        this.labels = new String[]{"Name", "Coordinates", "Type", "Region", "Main Star", "Discovered"};
        this.values = new Actor[]{this.nameValue, this.coordinatesValue, this.systemTypeValue, this.regionValue, this.centralStarValue, this.discoveredValue};
    }

    @Override
    public void construct() {
        this.clear();
        for (int i2 = 0; i2 < this.values.length; ++i2) {
            this.addLabel(this.labels[i2]);
            this.addValue(this.values[i2]);
            this.row();
        }
    }

    public void update(String starSystemName, Vector2i localPos, String centralStarName, String regionName, float discoveredFactor) {
        this.nameValue.setText(starSystemName);
        this.coordinatesValue.setText(localPos.x + " | " + localPos.y);
        this.centralStarValue.setText(centralStarName);
        this.systemTypeValue.setText("");
        this.discoveredValue.setValue(discoveredFactor);
        this.regionValue.setText(regionName != null ? regionName : "None");
    }

    public void update(Sector<StarSystem> starSystemSector, float discoveredPercent) {
        this.nameValue.setText(starSystemSector.getChunk().getName());
        this.coordinatesValue.setText(starSystemSector.getXCoordinates() + " | " + starSystemSector.getYCoordinates());
        this.centralStarValue.setText(starSystemSector.getChunk().getSun().getName());
        this.systemTypeValue.setText(starSystemSector.getChunk().getSettings().getName());
        this.discoveredValue.setValue(discoveredPercent / 100.0f);
        if (starSystemSector.getChunk().getRegion() != null) {
            this.regionValue.setText(starSystemSector.getChunk().getRegion().getRegionName());
        } else {
            this.regionValue.setText("None");
        }
    }

    public void update(Sector<StarSystem> starSystemSector, int xSector, int ySector, float discoveredPercent) {
        this.nameValue.setText(starSystemSector.getChunk().getName());
        this.coordinatesValue.setText(starSystemSector.getXCoordinates() + " | " + starSystemSector.getYCoordinates());
        this.centralStarValue.setText(starSystemSector.getChunk().getSun().getName());
        this.systemTypeValue.setText(starSystemSector.getChunk().getSettings().getName());
        this.discoveredValue.setValue(discoveredPercent / 100.0f);
        this.coordinatesValue.setText(xSector + " | " + ySector);
        if (starSystemSector.getChunk().getRegion() != null) {
            this.regionValue.setText(starSystemSector.getChunk().getRegion().getRegionName());
        } else {
            this.regionValue.setText("None");
        }
    }

    public void update(StarSystemSettings starSystemSettings, int xSector, int ySector) {
        if (starSystemSettings == null) {
            this.nameValue.setText("?");
            this.systemTypeValue.setText("?");
        } else {
            this.nameValue.setText(starSystemSettings.getName());
            this.systemTypeValue.setText(starSystemSettings.getName());
        }
        this.discoveredValue.setValue(0.0f);
        this.centralStarValue.setText("?");
        this.regionValue.setText("?");
        this.coordinatesValue.setText(xSector + " | " + ySector);
    }
}

