/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.game.menu.map.starmap.detail;

import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.Satellite;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;
import com.neutronio.astrax.ui.commons.text.AstraXLabel;

public class SpaceCraftDetailPanel
extends SimplePanel {
    private SimplePanel innerPanel;
    private AstraXLabel nameValue;
    private AstraXLabel typeValue;
    private AstraXLabel ownerValue;
    private AstraXLabel factionValue;
    private AstraXLabel conditionValue;

    public SpaceCraftDetailPanel(ComponentFactory componentFactory) {
        super(componentFactory, "detailpanel", "outset");
        this.innerPanel = new SimplePanel(componentFactory, "detailpanel", "tab-inner");
        this.innerPanel.top();
        this.nameValue = this.getLabel("-");
        this.typeValue = this.getLabel("-");
        this.ownerValue = this.getLabel("-");
        this.factionValue = this.getLabel("-");
        this.conditionValue = this.getLabel("-");
    }

    @Override
    public void construct() {
        this.clear();
        super.construct();
        this.innerPanel.construct();
        this.innerPanel.addRow("Ship Name", this.nameValue);
        this.innerPanel.row();
        this.innerPanel.addRow("Type", this.typeValue);
        this.innerPanel.row();
        this.innerPanel.addRow("Owner", this.ownerValue);
        this.innerPanel.row();
        this.innerPanel.addRow("Faction", this.factionValue);
        this.innerPanel.row();
        this.innerPanel.addRow("Condition", this.conditionValue);
        this.innerPanel.pack();
        this.addHeader("Spacecraft", 1);
        this.row();
        this.add(this.innerPanel).minWidth(300.0f).expand().fill().top();
    }

    public void update(Satellite spaceShip) {
        this.nameValue.setText(spaceShip.getName());
        this.typeValue.setText(spaceShip.getSatelliteGrid().name);
        this.ownerValue.setText("Player");
        this.conditionValue.setText(this.getCondition(spaceShip.getHpCurrentFactor()));
    }

    private String getCondition(float factor) {
        String condition = "Bad";
        if (factor > 0.4f) {
            condition = "Mediocre";
        }
        if (factor > 0.6f) {
            condition = "Good";
        }
        if (factor > 0.8f) {
            condition = "Excellent";
        }
        return condition;
    }
}

