/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.game.menu.map.starmap.detail;

import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.TextArea;
import com.neutronio.astrax.app.datapack.game.world.galaxy.planet.PlanetTrait;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;
import com.neutronio.astrax.ui.commons.text.AstraXLabel;

public class TraitDetailPanel
extends SimplePanel {
    private Image traitIcon;
    private AstraXLabel typeValue;
    private AstraXLabel pointsValue;
    private TextArea descriptionValue;

    public TraitDetailPanel(ComponentFactory componentFactory) {
        super(componentFactory, "detailpanel", "tab-inner");
        this.traitIcon = new Image(componentFactory.getSkin(), "trait_quake");
        this.add(this.traitIcon).size(64.0f, 64.0f).center();
        this.descriptionValue = new TextArea("-", componentFactory.getSkin());
        this.descriptionValue.setPrefRows(6.0f);
        this.descriptionValue.setDisabled(true);
        super.construct();
        this.add(this.descriptionValue).minWidth(300.0f).padTop(10.0f).fill();
        this.row();
        this.typeValue = this.getLabel("-");
        this.addRow("Type", this.typeValue);
        this.row();
        this.pointsValue = this.getLabel("-");
        this.addRow("Points", this.pointsValue);
        this.row();
        this.pack();
    }

    public void setTrait(PlanetTrait trait) {
        if (trait != null) {
            this.traitIcon.setDrawable(this.componentFactory.getSkin(), trait.icon);
            this.pointsValue.setText(trait.discoveryPoints);
            this.typeValue.setText(trait.category.name());
            this.descriptionValue.setText(trait.description);
        } else {
            this.traitIcon.setDrawable(this.componentFactory.getSkin(), "icon_inline_questionmark");
            this.pointsValue.setText("-");
            this.typeValue.setText("-");
            this.descriptionValue.setText("-");
        }
    }
}

