/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.game.menu.map.starmap.detail;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.neutronio.astrax.app.datapack.game.mechanics.discovery.TraitType;
import com.neutronio.astrax.app.datapack.game.world.galaxy.planet.PlanetTrait;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.AstraXComponent;
import com.neutronio.astrax.ui.commons.text.TextSelector;
import com.neutronio.astrax.ui.commons.widgets.SelectBoxWrapper;
import com.neutronio.astrax.ui.game.menu.map.starmap.detail.TraitDetailPanel;
import java.util.ArrayList;
import java.util.List;

public class TraitsPanel
extends AstraXComponent {
    private TextSelector<PlanetTrait> selector;
    private TraitDetailPanel traitDetailPanel;

    private static PlanetTrait getDummyTrait(String traitName, String icon) {
        PlanetTrait trait = new PlanetTrait();
        trait.name = traitName;
        trait.icon = icon;
        trait.discoveryPoints = (int)(Math.random() * 100.0);
        trait.description = "We discovered this trait!";
        trait.category = TraitType.HYDROSPHERIC;
        return trait;
    }

    public TraitsPanel(ComponentFactory componentFactory) {
        super(componentFactory);
        this.selector = new TextSelector(componentFactory);
        this.selector.addItem(new SelectBoxWrapper<PlanetTrait>("-", TraitsPanel.getDummyTrait("-", "trait_quake")));
        this.selector.addItem(new SelectBoxWrapper<PlanetTrait>("-", TraitsPanel.getDummyTrait("-", "trait_meteor")));
        this.selector.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (TraitsPanel.this.selector.getSelectedObject() != null) {
                    TraitsPanel.this.traitDetailPanel.setTrait((PlanetTrait)TraitsPanel.this.selector.getSelectedObject());
                }
            }
        });
        this.selector.setTextSpace(80.0f);
        this.add(this.selector).padRight(10.0f).fill();
        this.row();
        this.traitDetailPanel = new TraitDetailPanel(componentFactory);
        this.add(this.traitDetailPanel).fill();
    }

    public static List<SelectBoxWrapper<PlanetTrait>> wrap(List<PlanetTrait> traits) {
        ArrayList<SelectBoxWrapper<PlanetTrait>> wrapped = new ArrayList<SelectBoxWrapper<PlanetTrait>>();
        for (PlanetTrait trait : traits) {
            wrapped.add(new SelectBoxWrapper<PlanetTrait>(trait.name, trait));
        }
        return wrapped;
    }

    public void setTraits(List<PlanetTrait> traits) {
        if (traits.isEmpty()) {
            this.selector.setItems(new ArrayList());
            this.traitDetailPanel.setTrait(null);
        } else {
            this.selector.setItems(TraitsPanel.wrap(traits));
            this.traitDetailPanel.setTrait(null);
        }
    }
}

