/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.game.spacecraft;

import com.neutronio.astrax.app.datapack.game.mechanics.resources.Resource;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.tanks.TankManager;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.buttons.StaticIcon;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;
import com.neutronio.astrax.ui.commons.text.AstraXLabel;
import com.neutronio.astrax.ui.commons.text.TextProgressbar;
import com.neutronio.astrax.util.StandardFormats;

public class CompartmentPanel
extends SimplePanel {
    private StaticIcon resourceIcon;
    private AstraXLabel compartmentName;
    private AstraXLabel netValue;
    private TextProgressbar progressBar;

    public CompartmentPanel(ComponentFactory componentFactory) {
        super(componentFactory, "buttons", null);
        this.resourceIcon = new StaticIcon(componentFactory.getSkin(), "secondary-clear");
        this.compartmentName = new AstraXLabel(componentFactory, null);
        this.compartmentName.setEllipsis(true);
        this.netValue = new AstraXLabel(componentFactory, null);
        this.progressBar = new TextProgressbar(componentFactory);
        this.progressBar.setUsePercent(false);
        this.progressBar.setFormat(StandardFormats.FLOAT_COUNT);
        this.add(this.resourceIcon).padBottom(this.panelStyle.rowPadding).padRight(this.panelStyle.columnPadding);
        this.addValue(this.compartmentName).maxWidth(150.0f);
        this.addValue(this.progressBar).minWidth(100.0f);
        this.addValue(this.netValue);
        this.pack();
    }

    public void updateDisplayTexts(Resource resource) {
        this.resourceIcon.setInlineIcon(resource.icon);
        this.compartmentName.setText(resource.name);
    }

    public void updateDisplayTexts(String name, String icon) {
        this.resourceIcon.setInlineIcon(icon);
        this.compartmentName.setText(name);
    }

    public void updateValues(TankManager.TankCompartment compartment) {
        this.netValue.setText(StandardFormats.PERCENT.format(Float.valueOf(compartment.getProduction() - compartment.getConsumption())));
        this.progressBar.setBaseValue(compartment.getMax());
        this.progressBar.setValue(compartment.getStored() / compartment.getMax());
    }

    public void updateValues(float netRate, float stored, float max) {
        this.netValue.setText(StandardFormats.PERCENT.format(Float.valueOf(netRate)));
        this.progressBar.setBaseValue(max);
        this.progressBar.setValue(stored / max);
    }

    static interface CompartmentPanelListener {
        public void onConfigureButtonClicked();
    }
}

