/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.game.spacecraft;

import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.buttons.AstraXButton;
import com.neutronio.astrax.ui.commons.buttons.StaticIcon;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;
import com.neutronio.astrax.ui.commons.text.AstraXLabel;
import com.neutronio.astrax.ui.commons.text.TextProgressbar;
import com.neutronio.astrax.util.StandardFormats;

public class TankManagerEntry
extends SimplePanel {
    private StaticIcon icon;
    private AstraXLabel compartmentName;
    private AstraXLabel netValue;
    private AstraXLabel efficiencyValue;
    private TextProgressbar progressBar;
    private AstraXButton configureButton;

    public TankManagerEntry(ComponentFactory componentFactory) {
        super(componentFactory);
        this.icon = new StaticIcon(componentFactory.getSkin(), "secondary-clear");
        this.compartmentName = new AstraXLabel(componentFactory, null);
        this.compartmentName.setEllipsis(true);
        this.netValue = new AstraXLabel(componentFactory, null);
        this.efficiencyValue = new AstraXLabel(componentFactory, null);
        this.progressBar = new TextProgressbar(componentFactory);
        this.progressBar.setUsePercent(false);
        this.progressBar.setFormat(StandardFormats.FLOAT_COUNT);
        this.configureButton = new AstraXButton(componentFactory, "icon_inline_cog", "primary");
        this.add(this.configureButton).padBottom(this.panelStyle.rowPadding).padRight(this.panelStyle.columnPadding);
        this.add(this.icon).padBottom(this.panelStyle.rowPadding).padRight(this.panelStyle.columnPadding);
        this.addValue(this.compartmentName).maxWidth(150.0f);
        this.add(this.progressBar).fill().padBottom(this.panelStyle.rowPadding).padRight(this.panelStyle.columnPadding);
        this.addValue(this.netValue).minWidth(30.0f).maxWidth(50.0f);
        this.addValue(this.efficiencyValue).minWidth(50.0f).maxWidth(70.0f);
        this.pack();
    }

    public void prioritySetDisabled(boolean disabled) {
    }

    public void updatePriority(int priority) {
    }

    public void updateDisplayTexts(String name, String icon) {
        this.icon.setInlineIcon(icon);
        this.compartmentName.setText(name);
    }

    public void updateValues(float netRate, float efficiency) {
        this.netValue.setText(StandardFormats.PERCENT.format(Float.valueOf(netRate)));
        this.efficiencyValue.setText(StandardFormats.PERCENT.format(Float.valueOf(efficiency * 100.0f)) + " %");
        if (this.progressBar.isVisible()) {
            this.progressBar.setVisible(false);
        }
    }

    public void updateValues(float netRate, float stored, float max, float efficiency) {
        this.netValue.setText(StandardFormats.PERCENT.format(Float.valueOf(netRate)));
        this.efficiencyValue.setText(StandardFormats.PERCENT.format(Float.valueOf(efficiency * 100.0f)) + " %");
        this.progressBar.setBaseValue(max);
        this.progressBar.setValue(stored / max);
        if (!this.progressBar.isVisible()) {
            this.progressBar.setVisible(true);
        }
    }
}

