/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.game.spacecraft;

import com.badlogic.gdx.scenes.scene2d.ui.Tooltip;
import com.badlogic.gdx.scenes.scene2d.ui.VerticalGroup;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.datapack.game.mechanics.resources.Resource;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.tanks.TankManager;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.buttons.AstraXTextButton;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;
import com.neutronio.astrax.ui.commons.tab.FlexTab;
import com.neutronio.astrax.ui.commons.text.AstraXLabel;
import com.neutronio.astrax.ui.game.spacecraft.CompartmentPanel;
import com.neutronio.astrax.ui.game.spacecraft.TankManagerEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class TankManagerPanel
extends SimplePanel {
    private Logger logger = Logger.getLogger(this.getClass().getSimpleName());
    private Tooltip<AstraXLabel> tankToolTip;
    private Tooltip<AstraXLabel> consumerToolTip;
    private Tooltip<AstraXLabel> producerToolTip;
    private FlexTab tankCompartmentsTab;
    private VerticalGroup compartmentButtons;
    private TankManager tankManager;
    private Map<String, CompartmentPanel> compartmentPanels = new HashMap<String, CompartmentPanel>();
    private Map<String, Compartment> compartments = new HashMap<String, Compartment>();

    public TankManagerPanel(ComponentFactory componentFactory) {
        super(componentFactory);
        this.tankCompartmentsTab = new FlexTab(componentFactory);
        this.compartmentButtons = new VerticalGroup();
        this.compartmentButtons.pad(10.0f);
        this.tankToolTip = componentFactory.getToolTip("A tank holding resources in this circular flow");
        this.consumerToolTip = componentFactory.getToolTip("A consumer that uses up resources");
        this.producerToolTip = componentFactory.getToolTip("A producer that creates resources");
        AstraXLabel label = this.getLabel(componentFactory.translate("game_menu_spacecraft_tankManager_hint"));
        this.addValue(label).colspan(2);
        this.row();
    }

    public void init(TankManager tankManager) {
        this.tankManager = tankManager;
        for (Map.Entry<String, TankManager.TankCompartment> entry : this.tankManager.getCompartments().entrySet()) {
            Resource resource = (Resource)AstraXApp.astraX.getRepositoryFactory().findResourceByID(entry.getValue().getResourceID());
            SimplePanel compartmentPanel = new SimplePanel(this.componentFactory);
            compartmentPanel.align(2);
            Compartment compartment = new Compartment();
            compartment.total = new CompartmentPanel(this.componentFactory);
            compartment.total.updateDisplayTexts(resource);
            compartmentPanel.addValue(compartment.total);
            compartmentPanel.row();
            for (TankManager.Tank tank : entry.getValue().getTanks()) {
                TankManagerEntry tankPanel = new TankManagerEntry(this.componentFactory);
                tankPanel.updateDisplayTexts(tank.getName(), "icon_inline_fuel");
                tankPanel.prioritySetDisabled(true);
                tankPanel.addListener(this.tankToolTip);
                compartment.compartments.add(tankPanel);
                compartmentPanel.addValue(tankPanel);
                compartmentPanel.row();
            }
            for (TankManager.Producer producer : entry.getValue().getProducers()) {
                TankManagerEntry producerPanel = new TankManagerEntry(this.componentFactory);
                producerPanel.updateDisplayTexts(producer.getName(), "icon_inline_plus");
                producerPanel.prioritySetDisabled(true);
                producerPanel.addListener(this.producerToolTip);
                compartment.compartments.add(producerPanel);
                compartmentPanel.addValue(producerPanel);
                compartmentPanel.row();
            }
            for (TankManager.Consumer consumer : entry.getValue().getConsumers()) {
                TankManagerEntry consumerPanel = new TankManagerEntry(this.componentFactory);
                consumerPanel.updateDisplayTexts(consumer.getName(), "icon_inline_minus");
                consumerPanel.updatePriority(consumer.getPriority());
                consumerPanel.addListener(this.consumerToolTip);
                compartment.compartments.add(consumerPanel);
                compartmentPanel.addValue(consumerPanel);
                compartmentPanel.row();
            }
            compartmentPanel.pack();
            AstraXTextButton textButton = this.tankCompartmentsTab.addTabWithTextButton(resource.getName(), "secondary", compartmentPanel);
            this.compartmentButtons.addActor(textButton);
            this.compartments.put(entry.getKey(), compartment);
        }
        this.compartmentButtons.pack();
        this.tankCompartmentsTab.pack();
        this.addValue(this.compartmentButtons).align(2);
        this.addValue(this.tankCompartmentsTab.getContentStack()).align(2).expand().minWidth(ComponentFactory.SECONDARY_TAB_WIDTH - 200);
        this.pack();
        this.tankCompartmentsTab.getStackController().show(0);
    }

    public void update() {
        for (Map.Entry<String, TankManager.TankCompartment> entry : this.tankManager.getCompartments().entrySet()) {
            Compartment compartment = this.compartments.get(entry.getKey());
            compartment.total.updateValues(entry.getValue());
            int i2 = 0;
            for (TankManager.Tank tank : entry.getValue().getTanks()) {
                TankManagerEntry tankPanel = compartment.compartments.get(i2);
                tankPanel.updateValues(0.0f, tank.getStored(), tank.getMax(), 1.0f);
                ++i2;
            }
            for (TankManager.Producer producer : entry.getValue().getProducers()) {
                TankManagerEntry producerPanel = compartment.compartments.get(i2);
                producerPanel.updateValues(producer.getProduction(), producer.getResourceEfficiency());
                ++i2;
            }
            for (TankManager.Consumer consumer : entry.getValue().getConsumers()) {
                TankManagerEntry consumerPanel = compartment.compartments.get(i2);
                consumerPanel.updateValues(-consumer.getDemand(), consumer.getResourceEfficiency());
                ++i2;
            }
        }
    }

    private class Compartment {
        CompartmentPanel total;
        List<TankManagerEntry> compartments = new ArrayList<TankManagerEntry>();

        private Compartment() {
        }
    }
}

