/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.game.trade;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.neutronio.astrax.app.datapack.game.Trader;
import com.neutronio.astrax.app.datapack.game.mechanics.resources.Resource;
import com.neutronio.astrax.app.datapack.game.world.NPCTrader;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.CargoSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.Cargobay;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.Item;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.forms.AbstractForm;
import com.neutronio.astrax.ui.commons.forms.Form;
import com.neutronio.astrax.ui.commons.forms.ValidationResult;
import com.neutronio.astrax.ui.game.trade.LimboInfoPanel;
import com.neutronio.astrax.ui.game.trade.MerchantInfoPanel;
import com.neutronio.astrax.ui.game.trade.MerchantPanel;
import com.neutronio.astrax.ui.game.trade.MultiplierButtons;
import java.util.List;

public class BuyForm
extends AbstractForm {
    private float amountMultiplier = 1.0f;
    protected MultiplierButtons multiplierButtons;
    protected Trader player;
    protected MerchantPanel playerPanel;
    protected MerchantInfoPanel playerInfo;
    protected Cargobay<Resource> playerItems;
    protected Trader merchant;
    protected float merchantSellPriceMarkup = 1.0f;
    protected MerchantPanel merchantPanel;
    protected MerchantInfoPanel merchantInfo;
    protected Cargobay<Resource> merchantItems;
    protected MerchantPanel limboPanel;
    protected LimboInfoPanel limboInfo;
    protected Cargobay<Resource> itemsToBuy;

    public BuyForm(ComponentFactory factory) {
        super(factory, "default", "panel-tech-deco2");
        this.multiplierButtons = new MultiplierButtons(factory);
        this.multiplierButtons.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (event.getTarget().getUserObject() instanceof Integer) {
                    BuyForm.this.setAmountMultiplier(((Integer)event.getTarget().getUserObject()).intValue());
                }
            }
        });
        CargoSettings infiniteCargo = new CargoSettings(Float.MAX_VALUE);
        this.itemsToBuy = new Cargobay(infiniteCargo);
        this.limboPanel = new MerchantPanel(factory, 1, 5);
        this.limboPanel.setListener(new MerchantPanel.MerchantPanelListener(){

            @Override
            public void onItemClicked(Item<Resource> item) {
                float itemAmount = MathUtils.clamp(1.0f * BuyForm.this.amountMultiplier, 1.0f, item.getAmount());
                item.withAmount(itemAmount).withBasePrice(item.getObject().getValue());
                BuyForm.this.itemsToBuy.remove(item);
                BuyForm.this.merchantItems.add(item);
                BuyForm.this.updateLimbo();
                BuyForm.this.update();
            }
        });
        this.limboInfo = new LimboInfoPanel(this.componentFactory);
        this.limboInfo.update("Items to Buy");
        this.playerPanel = new MerchantPanel(this.componentFactory, 1, 5);
        this.playerPanel.setButtonsDisabled(true);
        this.playerInfo = new MerchantInfoPanel(this.componentFactory);
        this.merchantPanel = new MerchantPanel(this.componentFactory);
        this.merchantPanel.setListener(new MerchantPanel.MerchantPanelListener(){

            @Override
            public void onItemClicked(Item<Resource> item) {
                float itemAmount = MathUtils.clamp(1.0f * BuyForm.this.amountMultiplier, 1.0f, item.getAmount());
                item.withAmount(itemAmount).withBasePrice(item.basePrice * BuyForm.this.merchantSellPriceMarkup);
                BuyForm.this.itemsToBuy.add(item);
                BuyForm.this.merchantItems.remove(item);
                BuyForm.this.updateLimbo();
                BuyForm.this.update();
            }
        });
        this.merchantInfo = new MerchantInfoPanel(this.componentFactory);
        this.updateLimbo();
        this.add(this.multiplierButtons).padBottom(5.0f).colspan(3).right();
        this.row();
        this.add(this.playerInfo).fill().padBottom(5.0f);
        this.add(this.limboInfo).fill().padBottom(5.0f);
        this.add(this.merchantInfo).fill().padBottom(5.0f);
        this.row();
        this.add(this.playerPanel).top();
        this.add(this.limboPanel).padLeft(50.0f).padRight(50.0f);
        this.add(this.merchantPanel).top();
        this.row();
        this.pack();
    }

    public void setPlayer(Trader player) {
        this.player = player;
        this.playerInfo.update(player.getName());
        CargoSettings cargoSettings = new CargoSettings(player.getMaxWeight());
        this.playerItems = new Cargobay(cargoSettings);
        List<Item<Resource>> allItems = player.getInventory().getAllItems();
        for (Item<Resource> item : allItems) {
            this.playerItems.addWithRemainder(item);
        }
        this.playerPanel.setPriceMarkup(1.0f, false);
    }

    public void setMerchant(Trader merchant) {
        if (merchant instanceof NPCTrader) {
            NPCTrader npcTrader = (NPCTrader)merchant;
            this.merchantSellPriceMarkup = npcTrader.getMerchantCreationSettings().sellPriceModifier;
        }
        this.merchant = merchant;
        this.merchantInfo.update(merchant.getName());
        CargoSettings cargoSettings = new CargoSettings(merchant.getMaxWeight());
        this.merchantItems = new Cargobay(cargoSettings);
        List<Item<Resource>> allItems = merchant.getInventory().getAllItems();
        for (Item<Resource> item : allItems) {
            this.merchantItems.addWithRemainder(item.withBasePrice(item.basePrice * this.merchantSellPriceMarkup));
        }
        this.merchantPanel.setPriceMarkup(this.merchantSellPriceMarkup, false);
        this.limboPanel.setPriceMarkup(this.merchantSellPriceMarkup, false);
    }

    private void updateLimbo() {
        this.limboPanel.update(this.itemsToBuy);
        this.limboInfo.update(this.itemsToBuy.getValue(), this.itemsToBuy.getWeight());
    }

    public void update() {
        this.playerPanel.update(this.playerItems);
        this.playerInfo.update(this.player.getMoney(), this.playerItems.getWeight(), this.player.getInventory().getMaxWeight());
        this.merchantPanel.update(this.merchantItems);
        this.merchantInfo.update(this.merchant.getMoney(), this.merchantItems.getWeight(), this.merchant.getInventory().getMaxWeight());
        this.pack();
    }

    public void setAmountMultiplier(float amountMultiplier) {
        this.amountMultiplier = amountMultiplier;
    }

    public Cargobay<Resource> getItemsToBuy() {
        return this.itemsToBuy;
    }

    @Override
    public ValidationResult validateForm(ValidationResult result) {
        if (this.itemsToBuy.getItemCount() == 0.0f) {
            result.addMessage("No items to trade!");
            result.status(Form.ValidationStatus.INVALID);
        }
        if (this.itemsToBuy.getValue() > this.player.getMoney()) {
            result.addMessage("You can't afford this trade!");
            result.status(Form.ValidationStatus.INVALID);
        }
        if (!this.player.getInventory().canAddWeight(this.itemsToBuy.getWeight())) {
            result.addMessage("You can't carry all of these items!");
            result.status(Form.ValidationStatus.INVALID);
        }
        return result;
    }

    @Override
    public void resetForm() {
        this.resetValues();
    }

    @Override
    public void resetValues() {
        this.itemsToBuy.clear();
        this.setPlayer(this.player);
        this.setMerchant(this.merchant);
        this.updateLimbo();
        this.update();
    }
}

