/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.game.trade;

import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.IconLabel;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;
import com.neutronio.astrax.util.StandardFormats;

public class LimboInfoPanel
extends SimplePanel {
    protected IconLabel money;
    protected IconLabel weight;
    protected Label nameLabel;

    public LimboInfoPanel(ComponentFactory factory) {
        super(factory, "detailpanel", "outset");
        this.money = new IconLabel(factory, "clear-28x28");
        this.money.setTouchable(Touchable.disabled);
        this.money.setLabelAlign(16);
        this.money.set("icon_resource_chipcoin", "0");
        this.weight = new IconLabel(factory, "clear-28x28");
        this.weight.setTouchable(Touchable.disabled);
        this.weight.setLabelAlign(16);
        this.weight.set("icon_inline_weight_c", "0");
        HorizontalGroup traderGroup = new HorizontalGroup();
        traderGroup.space(10.0f);
        traderGroup.addActor(this.money);
        traderGroup.addActor(this.weight);
        this.nameLabel = new Label("", factory.getSkin(), "small-no-bg");
        this.addValue(this.nameLabel).left();
        this.row();
        this.addValue(traderGroup);
        this.pack();
    }

    public void update(String traderName) {
        this.nameLabel.setText(traderName);
    }

    public void update(float money, float weight) {
        this.money.setText(StandardFormats.MONEY_ITEM.format(Float.valueOf(money)));
        this.weight.setText(StandardFormats.WEIGHT.format(Float.valueOf(weight)));
    }
}

