/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.game.trade;

import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.IconLabel;
import com.neutronio.astrax.ui.commons.buttons.StaticIcon;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;
import com.neutronio.astrax.ui.commons.text.TextProgressbar;
import com.neutronio.astrax.util.StandardFormats;

public class MerchantInfoPanel
extends SimplePanel {
    protected IconLabel money;
    protected TextProgressbar weightBar;
    protected StaticIcon weightIcon;
    protected Label nameLabel;

    public MerchantInfoPanel(ComponentFactory factory) {
        super(factory, "detailpanel", "outset");
        this.money = new IconLabel(factory, "clear-28x28");
        this.money.setTouchable(Touchable.disabled);
        this.money.setLabelAlign(16);
        this.money.set("icon_resource_chipcoin", "0");
        this.weightBar = new TextProgressbar(this.componentFactory);
        this.weightBar.setUsePercent(false);
        this.weightBar.setFormat(StandardFormats.PERCENT);
        this.weightIcon = new StaticIcon(factory.getSkin(), "clear-28x28");
        this.weightIcon.setInlineIcon("icon_inline_weight_c");
        HorizontalGroup traderGroup = new HorizontalGroup();
        traderGroup.space(10.0f);
        traderGroup.addActor(this.money);
        traderGroup.addActor(this.weightBar);
        traderGroup.addActor(this.weightIcon);
        this.nameLabel = new Label("", factory.getSkin(), "small-no-bg");
        this.addValue(this.nameLabel).left();
        this.row();
        this.addValue(traderGroup);
        this.pack();
    }

    public void update(String traderName) {
        this.nameLabel.setText(traderName);
    }

    public void update(float money, float weight, float maxWeight) {
        this.weightBar.setBaseValue(maxWeight);
        this.weightBar.setValue(weight / maxWeight);
        this.money.setText(StandardFormats.MONEY_ITEM.format(Float.valueOf(money)));
    }
}

