/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.game.trade;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.Tooltip;
import com.badlogic.gdx.scenes.scene2d.ui.VerticalGroup;
import com.neutronio.astrax.app.datapack.game.mechanics.resources.Resource;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.Cargobay;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.Item;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.text.AstraXLabel;
import com.neutronio.astrax.ui.commons.widgets.BubblePaginator;
import com.neutronio.astrax.ui.editor.Palette;
import com.neutronio.astrax.ui.game.inventory.ItemInfoPanel;
import com.neutronio.astrax.ui.game.trade.TradeItemButton;
import com.neutronio.astrax.util.StandardFormats;
import java.util.List;

public class MerchantPanel
extends VerticalGroup {
    private static Color ERROR_COLOR;
    protected ComponentFactory factory;
    protected Label priceMarkupLabel;
    protected Palette<TradeItemButton, Item<Resource>> merchantPalette;
    protected BubblePaginator paginatorComponent;
    protected MerchantPanelListener listener;
    protected boolean buttonsDisabled;
    private Tooltip<ItemInfoPanel> itemToolTip;
    private ItemInfoPanel itemInfoPanel;

    public MerchantPanel(ComponentFactory factory) {
        this(factory, 2, 10);
    }

    public MerchantPanel(ComponentFactory factory, int columns, int itemCount) {
        this.space(10.0f);
        this.factory = factory;
        this.itemInfoPanel = new ItemInfoPanel(factory, "inset");
        this.itemInfoPanel.align(10);
        this.itemToolTip = new Tooltip(this.itemInfoPanel){

            @Override
            public void enter(InputEvent event, float x, float y, int pointer, Actor fromActor) {
                if (event.getTarget() == null || event.getTarget().getUserObject() == null) {
                    return;
                }
                if (event.getTarget().getUserObject() instanceof Item) {
                    Item item = (Item)event.getTarget().getUserObject();
                    MerchantPanel.this.itemInfoPanel.update(item);
                }
                super.enter(event, x, y, pointer, fromActor);
            }
        };
        Table inventoryTable = new Table();
        ERROR_COLOR = this.factory.getSkin().getColor("error").cpy().mul(1.3f);
        this.merchantPalette = new Palette(factory);
        this.merchantPalette.setColumns(columns);
        this.merchantPalette.setIconCount(itemCount);
        this.merchantPalette.setButtonProducer(new Palette.ButtonUpdater<TradeItemButton, Item<Resource>>(){

            @Override
            public TradeItemButton createButton(ComponentFactory componentFactory, String style) {
                TradeItemButton button = new TradeItemButton(componentFactory, "default", style);
                button.addListener(MerchantPanel.this.itemToolTip);
                button.setSquishable(false);
                button.setCanCheck(false);
                return button;
            }

            @Override
            public void updateButton(TradeItemButton button, Item item) {
                button.update(item);
                button.setDisabled(MerchantPanel.this.isButtonsDisabled());
            }

            @Override
            public void resetButton(TradeItemButton button) {
                button.update(null);
                button.setDisabled(true);
            }
        });
        this.merchantPalette.setListener(new Palette.PaletteListener<Item<Resource>>(){

            @Override
            public void onSelectedChanged(Item<Resource> selectedItem) {
                if (selectedItem == null) {
                    return;
                }
                Item<Resource> item = selectedItem.copy();
                if (MerchantPanel.this.getListener() != null) {
                    MerchantPanel.this.getListener().onItemClicked(item);
                }
            }
        });
        this.merchantPalette.fillWithButtons("trade-item");
        this.paginatorComponent = new BubblePaginator(factory);
        this.paginatorComponent.setPaginator(this.merchantPalette);
        this.priceMarkupLabel = new Label("100", factory.getSkin(), "default");
        this.priceMarkupLabel.setTouchable(Touchable.disabled);
        HorizontalGroup markupGroup = new HorizontalGroup();
        markupGroup.space(10.0f);
        markupGroup.addActor(new AstraXLabel(factory, "Price Markup", "default", null));
        markupGroup.addActor(this.priceMarkupLabel);
        inventoryTable.add(markupGroup).pad(5.0f).left();
        inventoryTable.row();
        inventoryTable.add(this.merchantPalette).pad(5.0f);
        inventoryTable.row();
        inventoryTable.add(this.paginatorComponent).pad(5.0f).center();
        inventoryTable.pack();
        this.addActor(inventoryTable);
    }

    public boolean isButtonsDisabled() {
        return this.buttonsDisabled;
    }

    public void setButtonsDisabled(boolean buttonsDisabled) {
        this.buttonsDisabled = buttonsDisabled;
    }

    public void setPriceMarkup(float priceMarkup, boolean isSelling) {
        this.priceMarkupLabel.setText(StandardFormats.PERCENT.format(Float.valueOf(priceMarkup * 100.0f)) + " %");
        if (isSelling) {
            if (priceMarkup < 1.0f) {
                this.priceMarkupLabel.setColor(ERROR_COLOR);
            } else if (priceMarkup > 1.0f) {
                this.priceMarkupLabel.setColor(this.factory.getSkin().getColor("success-bright"));
            } else {
                this.priceMarkupLabel.setColor(this.factory.getSkin().getColor("warning-bright"));
            }
        } else if (priceMarkup < 1.0f) {
            this.priceMarkupLabel.setColor(this.factory.getSkin().getColor("success-bright"));
        } else if (priceMarkup > 1.0f) {
            this.priceMarkupLabel.setColor(ERROR_COLOR);
        } else {
            this.priceMarkupLabel.setColor(this.factory.getSkin().getColor("warning-bright"));
        }
    }

    public void update(Cargobay<Resource> inventory) {
        List<Item<Resource>> allItems = inventory.getAllItems();
        int oldMaxPages = this.merchantPalette.getMaxPages();
        int oldIconCount = this.merchantPalette.getIconCount();
        this.merchantPalette.setItems(allItems);
        this.merchantPalette.updateToContent();
        if (allItems.size() > oldMaxPages * oldIconCount) {
            this.paginatorComponent.updateChange();
        }
    }

    public MerchantPanelListener getListener() {
        return this.listener;
    }

    public void setListener(MerchantPanelListener listener) {
        this.listener = listener;
    }

    public static interface MerchantPanelListener {
        public void onItemClicked(Item<Resource> var1);
    }
}

