/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.game.trade;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.datapack.game.Trader;
import com.neutronio.astrax.app.datapack.game.mechanics.resources.Resource;
import com.neutronio.astrax.app.datapack.game.world.NPCTrader;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.CargoSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.Cargobay;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.Item;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.forms.AbstractForm;
import com.neutronio.astrax.ui.commons.forms.Form;
import com.neutronio.astrax.ui.commons.forms.ValidationResult;
import com.neutronio.astrax.ui.commons.text.AstraXLabel;
import com.neutronio.astrax.ui.game.TraitIconArray;
import com.neutronio.astrax.ui.game.trade.LimboInfoPanel;
import com.neutronio.astrax.ui.game.trade.MerchantInfoPanel;
import com.neutronio.astrax.ui.game.trade.MerchantPanel;
import com.neutronio.astrax.ui.game.trade.MultiplierButtons;
import java.util.ArrayList;
import java.util.List;

public class SellForm
extends AbstractForm {
    private float amountMultiplier = 1.0f;
    private List<String> acceptedItems = new ArrayList<String>();
    protected MultiplierButtons multiplierButtons;
    protected Trader player;
    protected MerchantPanel playerPanel;
    protected MerchantInfoPanel playerInfo;
    protected Cargobay<Resource> playerItems;
    protected Trader merchant;
    protected float merchantBuyPriceMarkup = 1.0f;
    protected MerchantInfoPanel merchantInfo;
    protected Cargobay<Resource> merchantItems;
    protected TraitIconArray acceptedItemIcons;
    protected MerchantPanel limboPanel;
    protected LimboInfoPanel limboInfo;
    protected Cargobay<Resource> itemsToSell;

    public SellForm(ComponentFactory factory) {
        super(factory, "default", "panel-tech-deco2");
        this.multiplierButtons = new MultiplierButtons(factory);
        this.multiplierButtons.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (event.getTarget().getUserObject() instanceof Integer) {
                    SellForm.this.setAmountMultiplier(((Integer)event.getTarget().getUserObject()).intValue());
                }
            }
        });
        this.acceptedItemIcons = new TraitIconArray(factory.getSkin());
        this.acceptedItemIcons.setMaxIconsInRow(5);
        CargoSettings infiniteCargo = new CargoSettings(Float.MAX_VALUE);
        this.itemsToSell = new Cargobay(infiniteCargo);
        this.limboPanel = new MerchantPanel(factory, 1, 5);
        this.limboPanel.setListener(new MerchantPanel.MerchantPanelListener(){

            @Override
            public void onItemClicked(Item<Resource> item) {
                float itemAmount = MathUtils.clamp(1.0f * SellForm.this.amountMultiplier, 1.0f, item.getAmount());
                item.withAmount(itemAmount).withBasePrice(item.getObject().getValue());
                SellForm.this.itemsToSell.remove(item);
                SellForm.this.playerItems.add(item);
                SellForm.this.updateLimbo();
                SellForm.this.update();
            }
        });
        this.limboInfo = new LimboInfoPanel(this.componentFactory);
        this.limboInfo.update("Items to Sell");
        this.playerPanel = new MerchantPanel(this.componentFactory);
        this.playerPanel.setListener(new MerchantPanel.MerchantPanelListener(){

            @Override
            public void onItemClicked(Item<Resource> item) {
                if (SellForm.this.acceptedItems.contains(item.getObject().id)) {
                    float itemAmount = MathUtils.clamp(1.0f * SellForm.this.amountMultiplier, 1.0f, item.getAmount());
                    item.withAmount(itemAmount).withBasePrice(item.basePrice * SellForm.this.merchantBuyPriceMarkup);
                    SellForm.this.itemsToSell.add(item);
                    SellForm.this.playerItems.remove(item);
                    SellForm.this.updateLimbo();
                    SellForm.this.update();
                } else {
                    AstraXApp.astraX.showErrorAlert("Merchant does not accept this item!");
                }
            }
        });
        this.playerInfo = new MerchantInfoPanel(this.componentFactory);
        this.merchantInfo = new MerchantInfoPanel(this.componentFactory);
        this.updateLimbo();
        Table merchantItems = new Table();
        merchantItems.pad(5.0f);
        merchantItems.add(new AstraXLabel(this.componentFactory, "Accepted Items:", "default", null)).padBottom(5.0f);
        merchantItems.row();
        merchantItems.add(this.acceptedItemIcons);
        this.add(this.multiplierButtons).padBottom(5.0f).colspan(3).left();
        this.row();
        this.add(this.playerInfo).fill().padBottom(5.0f);
        this.add(this.limboInfo).fill().padBottom(5.0f);
        this.add(this.merchantInfo).fill().padBottom(5.0f);
        this.row();
        this.add(this.playerPanel).top();
        this.add(this.limboPanel).padLeft(50.0f).padRight(50.0f);
        this.add(merchantItems).top();
        this.row();
        this.pack();
    }

    public void setPlayer(Trader player) {
        this.player = player;
        this.playerInfo.update(player.getName());
        CargoSettings cargoSettings = new CargoSettings(player.getMaxWeight());
        this.playerItems = new Cargobay(cargoSettings);
        List<Item<Resource>> allItems = player.getInventory().getAllItems();
        for (Item<Resource> item : allItems) {
            this.playerItems.addWithRemainder(item);
        }
        this.playerPanel.setPriceMarkup(1.0f, true);
    }

    public void setMerchant(Trader merchant) {
        if (merchant instanceof NPCTrader) {
            this.acceptedItems.clear();
            this.acceptedItemIcons.clearChildren();
            NPCTrader npcTrader = (NPCTrader)merchant;
            this.merchantBuyPriceMarkup = npcTrader.getMerchantCreationSettings().buyPriceModifier;
            this.acceptedItems.addAll(npcTrader.getMerchantCreationSettings().buyItems);
            ArrayList<String> acceptedIcons = new ArrayList<String>();
            for (String string : npcTrader.getMerchantCreationSettings().buyItems) {
                Resource itemResource = (Resource)AstraXApp.astraX.findResource(string);
                acceptedIcons.add(itemResource.icon);
            }
            this.acceptedItemIcons.updateWith(acceptedIcons);
        }
        this.merchant = merchant;
        this.merchantInfo.update(merchant.getName());
        CargoSettings cargoSettings = new CargoSettings(merchant.getMaxWeight());
        this.merchantItems = new Cargobay(cargoSettings);
        List<Item<Resource>> allItems = merchant.getInventory().getAllItems();
        for (Item item : allItems) {
            this.merchantItems.addWithRemainder(item.withBasePrice(item.basePrice * this.merchantBuyPriceMarkup));
        }
        this.limboPanel.setPriceMarkup(this.merchantBuyPriceMarkup, true);
    }

    private void updateLimbo() {
        this.limboPanel.update(this.itemsToSell);
        this.limboInfo.update(this.itemsToSell.getValue(), this.itemsToSell.getWeight());
    }

    public void update() {
        this.playerPanel.update(this.playerItems);
        this.playerInfo.update(this.player.getMoney(), this.playerItems.getWeight(), this.player.getInventory().getMaxWeight());
        this.merchantInfo.update(this.merchant.getMoney(), this.merchantItems.getWeight(), this.merchant.getInventory().getMaxWeight());
        this.pack();
    }

    public void setAmountMultiplier(float amountMultiplier) {
        this.amountMultiplier = amountMultiplier;
    }

    public Cargobay<Resource> getItemsToSell() {
        return this.itemsToSell;
    }

    @Override
    public void resetValues() {
        this.itemsToSell.clear();
        this.setPlayer(this.player);
        this.setMerchant(this.merchant);
        this.updateLimbo();
        this.update();
    }

    @Override
    public ValidationResult validateForm(ValidationResult result) {
        if (this.itemsToSell.getItemCount() == 0.0f) {
            result.addMessage("No items to trade!");
            result.status(Form.ValidationStatus.INVALID);
        }
        if (this.itemsToSell.getValue() > this.merchant.getMoney()) {
            result.addMessage("Merchant can't afford this trade!");
            result.status(Form.ValidationStatus.INVALID);
        }
        if (!this.merchant.getInventory().canAddWeight(this.itemsToSell.getWeight())) {
            result.addMessage("Merchant can't carry all of these items!");
            result.status(Form.ValidationStatus.INVALID);
        }
        return result;
    }

    @Override
    public void resetForm() {
        this.resetValues();
    }
}

