/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.game.trade;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.neutronio.astrax.app.datapack.game.mechanics.resources.Resource;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.Item;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.IconLabel;
import com.neutronio.astrax.ui.commons.buttons.CompositeButton;
import com.neutronio.astrax.util.StandardFormats;

public class TradeItemButton
extends CompositeButton {
    protected Image itemIcon;
    protected IconLabel credits;
    protected Label nameText;
    protected Label amountText;

    public TradeItemButton(ComponentFactory factory, String styleName, String backgroundStyle) {
        super(factory, styleName, backgroundStyle);
        this.componentFactory = factory;
        this.setStyle(factory.getSkin().get(styleName, CompositeButton.CompositeButtonStyle.class));
        this.itemIcon = new Image();
        this.itemIcon.setTouchable(Touchable.disabled);
        this.itemIcon.setSize(48.0f, 48.0f);
        this.itemIcon.setPosition(10.0f, 10.0f);
        this.addActor(this.itemIcon);
        Table textGroup = new Table();
        this.nameText = new Label("", factory.getSkin(), "default-no-bg");
        this.nameText.setTouchable(Touchable.disabled);
        textGroup.add(this.nameText).fill().minSize(130.0f, 20.0f).padRight(10.0f);
        this.amountText = new Label("", factory.getSkin(), "default-no-bg");
        this.amountText.setTouchable(Touchable.disabled);
        this.amountText.setAlignment(16);
        textGroup.add(this.amountText).minSize(70.0f, 20.0f);
        textGroup.row();
        this.credits = new IconLabel(factory, "money");
        this.credits.setTouchable(Touchable.disabled);
        this.credits.set("icon_resource_chipcoin", "");
        this.credits.setIconVisible(false);
        this.credits.setLabelAlign(16);
        textGroup.add(this.credits).colspan(2).right();
        textGroup.pack();
        this.add(textGroup);
        textGroup.setPosition(30.0f, 15.0f);
        this.setSize(240.0f, 70.0f);
        this.pack();
        this.centerBackground();
    }

    public void update(Item<Resource> item) {
        if (item != null) {
            this.credits.setIconVisible(true);
            this.itemIcon.setVisible(true);
            this.itemIcon.setDrawable(this.componentFactory.getSkin().getDrawable(item.getIcon()));
            this.nameText.setText(item.getName());
            this.credits.setText(StandardFormats.MONEY_ITEM.format(Float.valueOf(item.getStackValue())));
            this.amountText.setText("x " + StandardFormats.FLOAT_COUNT.format(Float.valueOf(item.getAmount())));
            this.setUserObject(item);
        } else {
            this.credits.setIconVisible(false);
            this.itemIcon.setVisible(false);
            this.nameText.setText("");
            this.credits.setText("");
            this.amountText.setText("");
            this.setUserObject(null);
        }
    }

    @Override
    public void setDisabled(boolean disabled) {
        super.setDisabled(disabled);
        if (disabled) {
            this.itemIcon.setColor(Color.GRAY);
        } else {
            this.itemIcon.setColor(Color.WHITE);
        }
    }
}

