/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.hud;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.neutronio.astrax.app.datapack.EntityID;
import com.neutronio.astrax.app.datapack.game.world.NavTarget;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.sensors.TargetSorter;
import com.neutronio.astrax.gfx.ShapeGraphics;
import com.neutronio.astrax.util.StandardFormats;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import space.earlygrey.shapedrawer.ShapeDrawer;

public class CenterHUD
implements ShapeGraphics {
    private static float maxFlareTime = 2.0f;
    private float flareTime = 0.0f;
    private float time = 0.0f;
    private List<TargetSorter.Target> targets = new ArrayList<TargetSorter.Target>();
    private TargetSorter.Target selectedTarget;
    private Marker selectedTargetMarker;
    private List<TargetSorter.Target> bookmarks = new ArrayList<TargetSorter.Target>();
    private TargetSorter.Target selectedBookmark;
    private Marker selectedBookmarkMarker;
    private float displayedSpeed = 0.5f;
    private String thrusterGroup = "FLAT";
    private float selfAngle = 90.0f;
    private float cameraZoom = 0.0f;
    private CenterHUDStyle style;
    private float maxDistance = 2500.0f;
    private boolean debug = false;

    public CenterHUD(Skin skin) {
        this.setStyle(skin.get("default", CenterHUDStyle.class));
        this.selectedTargetMarker = new Marker();
        this.selectedTargetMarker.markerColor = this.style.selectionColor;
        this.selectedBookmarkMarker = new Marker();
    }

    public void setStyle(CenterHUDStyle style) {
        this.style = style;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public String getThrusterGroup() {
        return this.thrusterGroup;
    }

    public void setThrusterGroup(String thrusterGroup) {
        this.thrusterGroup = thrusterGroup;
    }

    public void addTarget(TargetSorter.Target target) {
        this.targets.add(target);
    }

    public void setTargets(List<TargetSorter.Target> targets) {
        this.targets = targets;
    }

    public void setBookmarks(List<TargetSorter.Target> targets) {
        this.bookmarks = targets;
    }

    public void setSelfAngle(float selfAngle) {
        this.selfAngle = selfAngle % 360.0f;
    }

    public void setDisplayedSpeed(float displayedSpeed) {
        this.displayedSpeed = displayedSpeed;
    }

    public void setCameraZoom(float cameraZoom) {
        this.cameraZoom = cameraZoom;
    }

    public void setSelectedTarget(TargetSorter.Target selectedTarget) {
        this.selectedTarget = selectedTarget;
    }

    public void setSelectedTargetByEntityID(EntityID entityID) {
        if (entityID == null) {
            this.deselectTarget();
            return;
        }
        for (TargetSorter.Target target : this.targets) {
            if (!Objects.equals(entityID, target.getTargetable().getID())) continue;
            this.selectedTarget = target;
            break;
        }
    }

    public void setSelectedBookmarkByEntityID(EntityID entityID) {
        if (entityID == null) {
            this.deselectBookmark();
            return;
        }
        for (TargetSorter.Target target : this.bookmarks) {
            if (!Objects.equals(entityID, target.getTargetable().getID())) continue;
            this.selectedBookmark = target;
            NavTarget navTarget = (NavTarget)target.getTargetable();
            this.selectedBookmarkMarker.markerColor = navTarget.getParentBookmark().color;
            break;
        }
    }

    public void deselectTarget() {
        this.selectedTarget = null;
    }

    public void deselectBookmark() {
        this.selectedBookmark = null;
    }

    public void flare() {
        this.flareTime = this.style.maxFlareTime;
    }

    private void renderSpeedIndicator(ShapeDrawer shapeDrawer) {
        shapeDrawer.setColor(this.style.color.r, this.style.color.g, this.style.color.b, 0.5f);
        shapeDrawer.filledRectangle((float)Gdx.graphics.getWidth() / 2.0f + 100.0f, (float)Gdx.graphics.getHeight() / 2.0f - this.style.speedMeterSize / 2.0f, 10.0f, this.style.speedMeterSize);
        shapeDrawer.setColor(this.style.color);
        shapeDrawer.filledRectangle((float)Gdx.graphics.getWidth() / 2.0f + 100.0f, (float)Gdx.graphics.getHeight() / 2.0f - this.style.speedMeterSize / 2.0f, 10.0f, this.style.speedMeterSize * MathUtils.clamp(this.displayedSpeed, 0.0f, 1.0f));
    }

    private void renderSelfMarker(ShapeDrawer shapeDrawer, float angle) {
        shapeDrawer.setDefaultLineWidth(this.style.markerLineWidth);
        float cos = (float)Math.cos(Math.toRadians(angle));
        float sin = (float)Math.sin(Math.toRadians(angle));
        float x = this.style.targetDiscRadius * cos;
        float y = this.style.targetDiscRadius * sin;
        float x2 = this.style.targetDiscRadius * 0.4f * cos;
        float y2 = this.style.targetDiscRadius * 0.4f * sin;
        shapeDrawer.setColor(this.style.color);
        shapeDrawer.line((float)Gdx.graphics.getWidth() / 2.0f + x2, (float)Gdx.graphics.getHeight() / 2.0f + y2, (float)Gdx.graphics.getWidth() / 2.0f + x, (float)Gdx.graphics.getHeight() / 2.0f + y, 3.0f);
    }

    private void renderBookmark(ShapeDrawer shapeDrawer, TargetSorter.Target target) {
        float alpha = Interpolation.slowFast.apply(1.0f, 0.3f, MathUtils.clamp(target.getDistance() / this.maxDistance, 0.0f, 1.0f));
        float x = (float)((double)this.style.targetDiscRadius * Math.cos(Math.toRadians(target.getAngle())));
        float y = (float)((double)this.style.targetDiscRadius * Math.sin(Math.toRadians(target.getAngle())));
        if (target.getDistance() < 1000.0f) {
            shapeDrawer.setDefaultLineWidth(this.style.markerLineWidth * 2.0f);
            float x2 = this.style.targetDiscRadius * 0.9f * (float)Math.cos(Math.toRadians(target.getAngle()));
            float y2 = this.style.targetDiscRadius * 0.9f * (float)Math.sin(Math.toRadians(target.getAngle()));
            shapeDrawer.line((float)Gdx.graphics.getWidth() / 2.0f + x2, (float)Gdx.graphics.getHeight() / 2.0f + y2, (float)Gdx.graphics.getWidth() / 2.0f + x, (float)Gdx.graphics.getHeight() / 2.0f + y);
        } else {
            shapeDrawer.setDefaultLineWidth(this.style.markerLineWidth);
            shapeDrawer.setColor(this.style.color.r, this.style.color.g, this.style.color.b, alpha);
            shapeDrawer.circle((float)Gdx.graphics.getWidth() / 2.0f + x, (float)Gdx.graphics.getHeight() / 2.0f + y, 10.0f);
            shapeDrawer.circle((float)Gdx.graphics.getWidth() / 2.0f + x, (float)Gdx.graphics.getHeight() / 2.0f + y, 12.0f + this.time * 1.7f);
        }
    }

    private void renderTarget(ShapeDrawer shapeDrawer, TargetSorter.Target target) {
        float alpha = Interpolation.slowFast.apply(1.0f, 0.3f, MathUtils.clamp(target.getDistance() / this.maxDistance, 0.0f, 1.0f));
        float x = (float)((double)this.style.targetDiscRadius * Math.cos(Math.toRadians(target.getAngle())));
        float y = (float)((double)this.style.targetDiscRadius * Math.sin(Math.toRadians(target.getAngle())));
        if (target.getDistance() < 1000.0f) {
            shapeDrawer.setDefaultLineWidth(this.style.markerLineWidth * 2.0f);
            float x2 = this.style.targetDiscRadius * 0.9f * (float)Math.cos(Math.toRadians(target.getAngle()));
            float y2 = this.style.targetDiscRadius * 0.9f * (float)Math.sin(Math.toRadians(target.getAngle()));
            shapeDrawer.line((float)Gdx.graphics.getWidth() / 2.0f + x2, (float)Gdx.graphics.getHeight() / 2.0f + y2, (float)Gdx.graphics.getWidth() / 2.0f + x, (float)Gdx.graphics.getHeight() / 2.0f + y);
        } else {
            shapeDrawer.setDefaultLineWidth(this.style.markerLineWidth);
            shapeDrawer.setColor(this.style.color.r, this.style.color.g, this.style.color.b, alpha);
            shapeDrawer.filledCircle((float)Gdx.graphics.getWidth() / 2.0f + x, (float)Gdx.graphics.getHeight() / 2.0f + y, 10.0f);
            shapeDrawer.circle((float)Gdx.graphics.getWidth() / 2.0f + x, (float)Gdx.graphics.getHeight() / 2.0f + y, 12.0f + this.time * 1.7f);
        }
    }

    public void render(ShapeDrawer shapeDrawer, float delta) {
        this.time = (this.time + delta * 3.0f) % 2.0f;
        if (this.flareTime > 0.0f) {
            this.flareTime -= 2.0f * delta;
        }
        if (this.style.renderShadows) {
            shapeDrawer.setDefaultLineWidth(this.style.baseLineWidth + 5.0f);
            shapeDrawer.setColor(Color.BLACK);
            shapeDrawer.circle((float)Gdx.graphics.getWidth() / 2.0f, (float)Gdx.graphics.getHeight() / 2.0f, this.style.radius);
        }
        shapeDrawer.setDefaultLineWidth(this.style.baseLineWidth);
        shapeDrawer.setColor(this.style.color);
        shapeDrawer.circle((float)Gdx.graphics.getWidth() / 2.0f, (float)Gdx.graphics.getHeight() / 2.0f, this.style.radius);
        if (this.flareTime > 0.0f) {
            float distance = Interpolation.pow2.apply(10.0f, 1.0f, this.flareTime);
            float alpha = Interpolation.pow2.apply(0.3f, 1.0f, this.flareTime);
            shapeDrawer.setColor(this.style.color.r, this.style.color.g, this.style.color.b, alpha);
            shapeDrawer.circle((float)Gdx.graphics.getWidth() / 2.0f, (float)Gdx.graphics.getHeight() / 2.0f, this.style.radius + distance);
            shapeDrawer.circle((float)Gdx.graphics.getWidth() / 2.0f, (float)Gdx.graphics.getHeight() / 2.0f, this.style.radius - distance);
        }
        for (TargetSorter.Target target : this.targets) {
            if (!(target.getDistance() < 2000.0f)) continue;
            this.renderTarget(shapeDrawer, target);
        }
        for (TargetSorter.Target target : this.bookmarks) {
            this.renderBookmark(shapeDrawer, target);
        }
        if (this.selectedTarget != null) {
            this.selectedTargetMarker.render(shapeDrawer, this.selectedTarget);
        }
        if (this.selectedBookmark != null) {
            this.selectedBookmarkMarker.render(shapeDrawer, this.selectedBookmark);
        }
        this.renderSelfMarker(shapeDrawer, this.selfAngle);
        this.renderSpeedIndicator(shapeDrawer);
    }

    public void draw(Batch batch) {
        this.style.font.setColor(this.style.color);
        this.style.font.draw(batch, StandardFormats.FLOAT_COUNT.format(Float.valueOf(this.selfAngle)) + " \u00b0", (float)Gdx.graphics.getWidth() / 2.0f + this.style.targetDiscRadius, (float)Gdx.graphics.getHeight() / 2.0f);
        this.style.font.draw(batch, "x " + StandardFormats.FLOAT_COUNT.format(Float.valueOf(this.cameraZoom)), (float)Gdx.graphics.getWidth() / 2.0f + this.style.targetDiscRadius, (float)Gdx.graphics.getHeight() / 2.0f - 20.0f);
        this.style.font.draw(batch, this.thrusterGroup, (float)Gdx.graphics.getWidth() / 2.0f + 100.0f, (float)Gdx.graphics.getHeight() / 2.0f - this.style.speedMeterSize / 2.0f - 15.0f);
        if (this.selectedTarget != null) {
            this.style.font.setColor(this.style.selectionColor);
            this.style.font.draw(batch, StandardFormats.DISTANCE.format(Float.valueOf(this.selectedTarget.getAngle())) + " \u00b0", (float)Gdx.graphics.getWidth() / 2.0f - this.style.radius - 60.0f, (float)Gdx.graphics.getHeight() / 2.0f);
            this.style.font.draw(batch, StandardFormats.DISTANCE.format(Float.valueOf(this.selectedTarget.getDistance())) + " m", (float)Gdx.graphics.getWidth() / 2.0f - this.style.radius - 60.0f, (float)Gdx.graphics.getHeight() / 2.0f - 20.0f);
            if (this.debug) {
                Vector2 coordinates = new Vector2();
                ((Actor)this.selectedTarget.getTargetable().getGraphics()).localToScreenCoordinates(coordinates);
                this.style.font.draw(batch, StandardFormats.VECTOR2_POS.format(Float.valueOf(coordinates.x), Float.valueOf(coordinates.y)) + " \u00b0", (float)Gdx.graphics.getWidth() / 2.0f - this.style.radius - 60.0f, (float)Gdx.graphics.getHeight() / 2.0f - 30.0f);
            }
        }
        this.style.font.setColor(Color.WHITE);
    }

    public static class CenterHUDStyle {
        public BitmapFont font;
        public Color color;
        public Color selectionColor;
        private boolean renderShadows = false;
        private float baseLineWidth = 5.0f;
        private float markerLineWidth = 1.0f;
        private float radius = 200.0f;
        private float targetDiscRadius = 220.0f;
        private float speedMeterSize = 70.0f;
        private float maxFlareTime = 2.0f;
    }

    private class Marker {
        private float currentAngle = 0.0f;
        private Color markerColor;

        private Marker() {
        }

        private void render(ShapeDrawer shapeDrawer, TargetSorter.Target target) {
            shapeDrawer.setDefaultLineWidth(CenterHUD.this.style.markerLineWidth);
            this.currentAngle = MathUtils.lerpAngle(this.currentAngle, (float)Math.toRadians(target.getAngle()), Gdx.graphics.getDeltaTime() * 5.5f);
            float x = (float)((double)CenterHUD.this.style.targetDiscRadius * Math.cos(this.currentAngle));
            float y = (float)((double)CenterHUD.this.style.targetDiscRadius * Math.sin(this.currentAngle));
            float markerSize = target.getDistance() < CenterHUD.this.maxDistance * 5.0f ? Interpolation.pow2.apply(20.0f, 10.0f, target.getDistance() / (CenterHUD.this.maxDistance * 5.0f)) : 10.0f;
            shapeDrawer.setDefaultLineWidth(CenterHUD.this.style.markerLineWidth * 2.0f);
            shapeDrawer.setColor(this.markerColor);
            shapeDrawer.circle((float)Gdx.graphics.getWidth() / 2.0f + x, (float)Gdx.graphics.getHeight() / 2.0f + y, markerSize);
            float x2 = CenterHUD.this.style.targetDiscRadius * 0.8f * (float)Math.cos(this.currentAngle);
            float y2 = CenterHUD.this.style.targetDiscRadius * 0.8f * (float)Math.sin(this.currentAngle);
            shapeDrawer.line((float)Gdx.graphics.getWidth() / 2.0f + x2, (float)Gdx.graphics.getHeight() / 2.0f + y2, (float)Gdx.graphics.getWidth() / 2.0f + x, (float)Gdx.graphics.getHeight() / 2.0f + y);
        }
    }
}

