/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.hud;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.neutronio.astrax.gfx.ShapeGraphics;
import com.neutronio.astrax.ui.hud.ShapeStyle;
import space.earlygrey.shapedrawer.ShapeDrawer;

public class CircleBar
implements ShapeGraphics {
    protected ShapeStyle style;

    public CircleBar(Skin skin) {
        this.setStyle(skin.get("default", ShapeStyle.class));
    }

    public ShapeStyle getStyle() {
        return this.style;
    }

    public void setStyle(ShapeStyle style) {
        this.style = style;
    }

    public void render(ShapeDrawer shapeDrawer, Color barColor, float x, float y, float width, float height, float startAngle, float factor) {
        Gdx.gl.glEnable(3042);
        Gdx.gl.glBlendFunc(770, 771);
        factor = MathUtils.clamp(factor, 0.0f, 1.0f);
        float sizeFactor = (width + height) / 2.0f / 5000.0f;
        float arcLength = 1.5707964f;
        float lineWidth = Interpolation.pow2.apply((float)this.style.thickLineWidth * 0.7f, (float)this.style.thickLineWidth * 1.7f, sizeFactor);
        float spacing = MathUtils.clamp(Interpolation.pow2.apply(1.5f, 1.1f, sizeFactor), 1.1f, 1.5f);
        shapeDrawer.setDefaultLineWidth(lineWidth);
        shapeDrawer.setColor(this.style.color);
        shapeDrawer.arc(x + width / 2.0f, y + height / 2.0f, width / 2.0f * spacing, startAngle, arcLength);
        shapeDrawer.setDefaultLineWidth(lineWidth * 0.5f);
        shapeDrawer.setColor(barColor);
        shapeDrawer.arc(x + width / 2.0f, y + height / 2.0f, width / 2.0f * spacing, startAngle, arcLength * factor);
    }
}

