/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.hud;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.text.AstraXLabel;
import com.neutronio.astrax.ui.hud.ShapeStyle;
import com.neutronio.astrax.util.StandardFormats;
import com.neutronio.astrax.util.animation.Tweening;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import space.earlygrey.shapedrawer.ShapeDrawer;

public class Gauge
extends Group {
    private ComponentFactory factory;
    private ShapeDrawer shapeDrawer;
    private ShapeStyle style;
    private BitmapFont fontLarge;
    private BitmapFont fontSmall;
    private Image icon;
    private Map<String, Needle> needles = new HashMap<String, Needle>();
    private List<Marker> markers = new ArrayList<Marker>();
    private Marker startMarker;
    private Marker middleMarker;
    private Marker endMarker;
    private AstraXLabel valueLabel;
    protected Color bodyColor;
    protected float start = (float)Math.toRadians(225.0);
    protected float end = (float)Math.toRadians(0.0);
    public float radius;
    public boolean renderDialText = true;
    public boolean renderNeedleText = true;
    public boolean renderCenter = true;
    public boolean muteAlerts = false;
    public String displayedNeedle = null;

    public Gauge(ComponentFactory factory, String iconDrawable, float radius) {
        this.factory = factory;
        this.radius = radius;
        this.icon = new Image(factory.getSkin().getDrawable(iconDrawable));
        this.icon.setAlign(1);
        this.icon.setOrigin(1);
        this.icon.setPosition(-this.icon.getWidth() / 2.0f, -this.icon.getHeight() / 2.0f);
        this.addActor(this.icon);
        this.setStyle(factory.getSkin().get(ShapeStyle.class));
        this.fontLarge = factory.getSkin().getFont("tcf_14px");
        this.fontSmall = factory.getSkin().getFont("default");
        this.startMarker = new Marker("0", this.start, radius, radius * 0.3f, this.style.color);
        this.middleMarker = new Marker(" ", this.start / 2.0f, radius, radius * 0.5f, this.style.color);
        this.endMarker = new Marker("1", this.end, radius, radius * 0.3f, this.style.color);
        this.markers.add(this.startMarker);
        this.markers.add(this.middleMarker);
        this.markers.add(this.endMarker);
        this.valueLabel = new AstraXLabel(factory, "", "default", "border");
        this.valueLabel.setPosition(-15.0f, -45.0f);
        this.valueLabel.setSize(90.0f, 25.0f);
        this.valueLabel.setAlignment(16, 1);
        this.valueLabel.setTouchable(Touchable.disabled);
        this.addActor(this.valueLabel);
    }

    public void setShapeDrawer(ShapeDrawer shapeDrawer) {
        this.shapeDrawer = shapeDrawer;
    }

    public void setStyle(ShapeStyle style) {
        this.style = style;
    }

    public void customizeMarkers(String startMarkerText, String middleMarkerText, String endMarkerText) {
        this.startMarker.display = startMarkerText;
        this.middleMarker.display = middleMarkerText;
        this.endMarker.display = endMarkerText;
    }

    @Override
    public void setColor(Color color) {
        this.bodyColor = color = color.cpy();
        this.startMarker.color = color;
        this.middleMarker.color = color;
        this.endMarker.color = color;
    }

    public Needle getNeedle(String identifier) {
        return this.needles.get(identifier);
    }

    public void addMarker(String display, float angle, float innerRadius, float outerRadius, Color color) {
        this.markers.add(new Marker(display, angle, innerRadius, outerRadius, color));
    }

    public void addNeedle(String key, float innerRadius, float outerRadius, Color color, Color blinkColor) {
        if (key == null) {
            return;
        }
        this.needles.put(key, new Needle(innerRadius, outerRadius, color, blinkColor));
    }

    public void addToNeedleValue(String key, float delta) {
        if (!this.needles.containsKey(key)) {
            return;
        }
        this.needles.get(key).setValue(delta + this.needles.get((Object)key).currentFactor);
    }

    public void setNeedleValue(String key, float factor) {
        if (!this.needles.containsKey(key)) {
            return;
        }
        this.needles.get(key).setValue(MathUtils.clamp(factor, 0.0f, 1.0f));
    }

    public void setDisplayedNeedle(String displayedNeedle) {
        this.displayedNeedle = displayedNeedle;
    }

    public void setRenderDialText(boolean renderDialText) {
        this.renderDialText = renderDialText;
    }

    public void setRenderNeedleText(boolean renderNeedleText) {
        this.renderNeedleText = renderNeedleText;
    }

    public void setRenderCenter(boolean renderCenter) {
        this.renderCenter = renderCenter;
    }

    public void setMuteAlerts(boolean muteAlerts) {
        this.muteAlerts = muteAlerts;
    }

    public AstraXLabel getValueLabel() {
        return this.valueLabel;
    }

    public void setValueLabel(AstraXLabel valueLabel) {
        this.valueLabel = valueLabel;
    }

    @Override
    public void act(float delta) {
        super.act(delta);
    }

    @Override
    protected void drawChildren(Batch batch, float parentAlpha) {
        if (this.displayedNeedle != null && this.needles.containsKey(this.displayedNeedle)) {
            Needle needle = this.needles.get(this.displayedNeedle);
            this.valueLabel.setText(needle.format.format(Float.valueOf(needle.currentFactor * needle.baseValue)));
            this.valueLabel.setColor(!needle.blinking ? needle.color : needle.blinkColor);
        }
        this.shapeDrawer.setColor(this.bodyColor);
        this.shapeDrawer.setDefaultLineWidth(3.0f);
        this.shapeDrawer.arc(0.0f, 0.0f, this.radius, this.end, this.start);
        if (this.renderCenter) {
            this.shapeDrawer.filledCircle(0.0f, 0.0f, 16.0f);
        }
        super.drawChildren(batch, parentAlpha);
        for (Marker marker : this.markers) {
            marker.render(this.shapeDrawer);
        }
        for (Needle needle : this.needles.values()) {
            needle.render(Gdx.graphics.getDeltaTime(), this.shapeDrawer);
        }
    }

    @Override
    public String toString() {
        return "Gauge{style=" + this.style + '}';
    }

    public class Marker {
        String display;
        float innerRadius;
        float outerRadius;
        Color color;
        float angle;
        private float[] vertices = new float[4];
        private float[] fontPosition = new float[2];

        public Marker(String display, float angle, float innerRadius, float outerRadius, Color color) {
            this.display = display;
            this.innerRadius = innerRadius;
            this.outerRadius = outerRadius;
            this.color = color;
            this.setAngle(angle);
        }

        public void setAngle(float angleRadians) {
            this.angle = angleRadians;
            this.vertices[0] = (float)((double)this.outerRadius * Math.cos(this.angle));
            this.vertices[1] = (float)((double)this.outerRadius * Math.sin(this.angle));
            this.vertices[2] = (float)((double)this.innerRadius * Math.cos(this.angle));
            this.vertices[3] = (float)((double)this.innerRadius * Math.sin(this.angle));
            this.fontPosition[0] = (float)((double)(this.innerRadius * 0.6f) * Math.cos(this.angle));
            this.fontPosition[1] = (float)((double)(this.innerRadius * 0.6f) * Math.sin(this.angle) - 6.0);
        }

        private void render(ShapeDrawer shapeDrawer) {
            shapeDrawer.setDefaultLineWidth(3.0f);
            shapeDrawer.setColor(this.color);
            shapeDrawer.line(this.vertices[0], this.vertices[1], this.vertices[2], this.vertices[3]);
            if (Gauge.this.renderDialText) {
                this.renderLabel(shapeDrawer.getBatch(), Gauge.this.fontSmall);
            }
        }

        protected void renderLabel(Batch batch, BitmapFont font) {
            font.setColor(this.color);
            font.draw(batch, this.display, this.fontPosition[0], this.fontPosition[1]);
            font.setColor(Color.WHITE);
        }
    }

    public class Needle {
        protected float innerRadius;
        protected float outerRadius;
        protected Color color;
        protected Color blinkColor;
        protected boolean blinking;
        protected float targetFactor;
        protected float currentFactor;
        protected float baseValue;
        private Label valueLabel;
        protected boolean drawValue = true;
        protected StandardFormats format = StandardFormats.FLOAT_COUNT;
        protected String blinkSound = "alert1";
        protected float blinkInterval = 0.5f;
        protected boolean blinkingEnabled = true;
        protected float blinkBelow = 0.25f;
        protected float blinkTimer = 1.0f;

        public Needle(float innerRadius, float outerRadius, Color color, Color blinkColor) {
            this.innerRadius = innerRadius;
            this.outerRadius = outerRadius;
            this.color = color;
            this.blinkColor = blinkColor;
        }

        private void render(float delta, ShapeDrawer shapeDrawer) {
            if (this.blinkingEnabled) {
                if (this.currentFactor < this.blinkBelow) {
                    this.blinkTimer = (float)((double)this.blinkTimer - MathUtils.clamp((double)delta, 1.0E-4, 1.0));
                    if (this.blinkTimer < 0.0f) {
                        this.blinkTimer = this.blinkInterval;
                        boolean bl = this.blinking = !this.blinking;
                        if (this.blinkSound != null && this.blinking && !Gauge.this.muteAlerts) {
                            Gauge.this.factory.playUISound(this.blinkSound, 0.5f);
                            Gauge.this.icon.addAction(Tweening.getScaleRumble());
                        }
                    }
                } else if (this.blinking) {
                    this.blinking = false;
                    this.blinkTimer = this.blinkInterval;
                }
            }
            this.currentFactor = this.currentFactor * (1.0f - 2.0f * delta) + this.targetFactor * (2.0f * delta);
            this.renderNeedle(shapeDrawer, this.innerRadius, this.outerRadius, MathUtils.lerp(Gauge.this.start, Gauge.this.end, this.currentFactor));
        }

        protected void renderNeedle(ShapeDrawer shapeDrawer, float innerRadius, float outerRadius, float angle) {
            float x1 = (float)((double)innerRadius * Math.cos(angle));
            float y1 = (float)((double)innerRadius * Math.sin(angle));
            float x2 = (float)((double)outerRadius * Math.cos(angle));
            float y2 = (float)((double)outerRadius * Math.sin(angle));
            if (this.blinking) {
                shapeDrawer.setDefaultLineWidth(4.0f * Interpolation.sine.apply(1.0f, 3.0f, this.blinkTimer / this.blinkInterval));
            } else {
                shapeDrawer.setDefaultLineWidth(4.0f);
            }
            shapeDrawer.setColor(!this.blinking ? this.color : this.blinkColor);
            shapeDrawer.line(x1, y1, x2, y2);
        }

        public void setValue(float value) {
            this.targetFactor = value;
        }

        public void setDrawValue(boolean drawValue) {
            this.drawValue = drawValue;
        }

        public void setFormat(StandardFormats format) {
            this.format = format;
        }

        public void setBaseValue(float baseValue) {
            this.baseValue = baseValue;
        }

        public void setBlinkSound(String blinkSound) {
            this.blinkSound = blinkSound;
        }

        public void setBlinkInterval(float blinkInterval) {
            this.blinkInterval = blinkInterval;
        }

        public boolean isBlinkingEnabled() {
            return this.blinkingEnabled;
        }

        public void setBlinkingEnabled(boolean blinkingEnabled) {
            this.blinkingEnabled = blinkingEnabled;
        }

        public float getBlinkBelow() {
            return this.blinkBelow;
        }

        public void setBlinkBelow(float blinkBelow) {
            this.blinkBelow = blinkBelow;
        }
    }

    public static class GaugeStyle {
        public Drawable background;
        public Drawable pointer;
        public Drawable pointerBlink;
        public float startAngleDeg;
        public float endAngleDeg;
        public float pointerOffsetX;
        public float pointerOffsetY;
        public float pointerCenterOfRotationX;
        public float pointerCenterOfRotationY;
        public float iconPositionX;
        public float iconPositionY;
    }
}

