/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.hud;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.neutronio.astrax.app.Message;
import com.neutronio.astrax.app.datapack.EntityID;
import com.neutronio.astrax.app.datapack.game.DiscoveryTarget;
import com.neutronio.astrax.app.datapack.game.mechanics.discovery.DiscoveredStatus;
import com.neutronio.astrax.app.datapack.game.world.Player;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.Satellite;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.targeting.DiscoverySystem;
import com.neutronio.astrax.sfx.SoundManager;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.text.AstraXLabel;
import com.neutronio.astrax.ui.commons.widgets.AlertStack;
import com.neutronio.astrax.ui.game.TrackerButtonListener;
import com.neutronio.astrax.ui.hud.CenterHUD;
import com.neutronio.astrax.ui.hud.HUDActionPanel;
import com.neutronio.astrax.ui.hud.ObjectHUD;
import com.neutronio.astrax.ui.hud.SpaceCraftDashboard;
import com.neutronio.astrax.ui.hud.ToggableTargetList;
import com.neutronio.astrax.ui.hud.TopBar;
import java.util.LinkedList;
import java.util.Objects;

public class HUD
extends Group {
    private SoundManager uiSoundManager;
    private ComponentFactory factory;
    private TopBar topBar;
    private SpaceCraftDashboard spaceCraftDashboard;
    private ToggableTargetList targetList;
    private ToggableTargetList bookmarkList;
    private ObjectHUD objectHUD;
    private CenterHUD centerHUD;
    private AstraXLabel contextActionLabel;
    private AlertStack messageGrowl;
    protected HUDActionPanel hudActionPanel;
    private LinkedList<HUDMessage> messages = new LinkedList();
    private DiscoveryTarget selectedTarget = null;
    private TrackerButtonListener listener;

    public HUD(ComponentFactory factory, SoundManager uiSoundManager) {
        this.uiSoundManager = uiSoundManager;
        this.factory = factory;
        Skin skin = factory.getSkin();
        this.hudActionPanel = new HUDActionPanel(factory);
        this.spaceCraftDashboard = new SpaceCraftDashboard(factory);
        this.spaceCraftDashboard.setPosition((float)Gdx.graphics.getWidth() / 2.0f - this.spaceCraftDashboard.getWidth() / 2.0f, 15.0f);
        this.hudActionPanel.setPosition((float)Gdx.graphics.getWidth() / 2.0f - this.spaceCraftDashboard.getWidth() / 2.0f, 15.0f + this.spaceCraftDashboard.getHeight());
        this.addActor(this.spaceCraftDashboard);
        this.addActor(this.hudActionPanel);
        this.targetList = new ToggableTargetList(factory, "Targets", true);
        this.targetList.align(10);
        this.targetList.construct();
        this.targetList.setPosition(15.0f, (float)Gdx.graphics.getHeight() - this.targetList.getHeight() - 15.0f);
        this.addActor(this.targetList);
        this.bookmarkList = new ToggableTargetList(factory, "Bookmarks", false);
        this.bookmarkList.align(10);
        this.bookmarkList.construct();
        this.bookmarkList.setPosition((float)Gdx.graphics.getWidth() - this.bookmarkList.getWidth() - 15.0f, (float)Gdx.graphics.getHeight() - this.bookmarkList.getHeight() - 15.0f);
        this.addActor(this.bookmarkList);
        this.topBar = new TopBar(factory);
        this.topBar.pad(5.0f);
        this.topBar.setPosition((float)Gdx.graphics.getWidth() / 2.0f - this.topBar.getWidth() / 2.0f, (float)Gdx.graphics.getHeight() - this.topBar.getHeight());
        this.addActor(this.topBar);
        this.objectHUD = new ObjectHUD(factory);
        this.objectHUD.construct();
        this.objectHUD.setPosition(15.0f, 15.0f, 12);
        this.addActor(this.objectHUD);
        this.messageGrowl = new AlertStack(factory, "compact", 6);
        this.messageGrowl.setWidth(400.0f);
        this.messageGrowl.setPosition(7.0f, (float)Gdx.graphics.getHeight() / 2.0f - this.messageGrowl.getHeight() / 2.0f - 50.0f);
        this.addActor(this.messageGrowl);
        this.centerHUD = new CenterHUD(factory.getSkin());
        this.contextActionLabel = new AstraXLabel(factory, "-", "contextAction", "label");
        this.contextActionLabel.setFontScale(1.5f);
        this.contextActionLabel.addAction(Actions.forever(Actions.sequence((Action)Actions.moveBy(0.0f, 20.0f, 0.7f), (Action)Actions.moveBy(0.0f, -20.0f, 0.3f))));
        this.addActor(this.contextActionLabel);
    }

    public HUDActionPanel getHudActionPanel() {
        return this.hudActionPanel;
    }

    public void setListener(TrackerButtonListener listener) {
        this.listener = listener;
        this.bookmarkList.getTargetList().setListener(listener);
        this.targetList.getTargetList().setListener(listener);
    }

    public void hideContextHint() {
        this.contextActionLabel.addAction(Actions.fadeOut(0.5f));
    }

    public void showContextHint(String message) {
        this.contextActionLabel.setText(message);
        this.contextActionLabel.pack();
        this.contextActionLabel.setPosition((float)Gdx.graphics.getWidth() / 2.0f - this.contextActionLabel.getWidth() / 2.0f, (float)Gdx.graphics.getHeight() / 2.0f - 200.0f);
        this.contextActionLabel.addAction(Actions.fadeIn(1.0f));
    }

    public void showContextHintWithShortcut(String shortcut, String action) {
        String translated = this.factory.translate("game_context_hint_actions", shortcut, action);
        this.contextActionLabel.setText(translated);
        this.contextActionLabel.pack();
        this.contextActionLabel.setPosition((float)Gdx.graphics.getWidth() / 2.0f - this.contextActionLabel.getWidth() / 2.0f, (float)Gdx.graphics.getHeight() / 2.0f - 200.0f);
        this.contextActionLabel.addAction(Actions.fadeIn(1.0f));
    }

    @Deprecated
    public void setGodmode(boolean godmode) {
    }

    public DiscoveryTarget getSelectedTarget() {
        return this.selectedTarget;
    }

    public void showQuickMessage(Message ... message) {
        for (Message msg : message) {
            this.messageGrowl.showMessage(msg);
        }
        this.uiSoundManager.playSoundOnce("click_soft2");
    }

    public void showQuickMessage(String ... message) {
        for (String msg : message) {
            this.messageGrowl.showSuccessGrowl(msg);
        }
        this.uiSoundManager.playSoundOnce("click_soft2");
    }

    public void showQuickWarning(String ... message) {
        for (String msg : message) {
            this.messageGrowl.showWarningGrowl(msg);
        }
        this.uiSoundManager.playSoundOnce("warning");
    }

    public void showQuickError(String ... message) {
        for (String msg : message) {
            this.messageGrowl.showErrorGrowl(msg);
        }
        this.uiSoundManager.playSoundOnce("error");
    }

    public void showQuickMessage(String message, String sound) {
        this.messageGrowl.showWarningGrowl(message);
        this.uiSoundManager.playSoundOnce(sound);
    }

    public void updateDiscoveredPercentage(float discovery) {
        this.topBar.updateDiscovery(discovery);
    }

    public void updateEncumbrance(float encumbrance) {
        this.topBar.updateEncumbrance(encumbrance);
    }

    public void setSelectedBookmark(EntityID entityID) {
        this.centerHUD.setSelectedBookmarkByEntityID(entityID);
        this.bookmarkList.getTargetList().selectTarget(entityID);
    }

    public boolean isSelectedBookmark(EntityID entityID) {
        return Objects.equals(this.bookmarkList.getTargetList().getSelectedTargetID(), entityID);
    }

    public void updateSelectedTarget(DiscoveryTarget discoveryTarget) {
        this.centerHUD.setSelectedTargetByEntityID(discoveryTarget != null ? discoveryTarget.target.getID() : null);
        this.objectHUD.updateWith(discoveryTarget);
        this.targetList.getTargetList().selectTarget(discoveryTarget != null ? discoveryTarget.target.getID() : null);
        this.selectedTarget = discoveryTarget;
    }

    public void updateGauges(Satellite satellite) {
        this.spaceCraftDashboard.updateGauges(satellite);
    }

    public void updateCenterHUD(float currentZoom, float displayedSpeed, float selfAngle) {
        this.centerHUD.setCameraZoom(currentZoom);
        this.centerHUD.setDisplayedSpeed(displayedSpeed);
        this.centerHUD.setSelfAngle(selfAngle);
    }

    public void updateSensorDisplay(Satellite playerSatellite, DiscoveredStatus status) {
        this.targetList.getTargetList().setDiscoverySystem(playerSatellite.getSystem(DiscoverySystem.class));
        this.updateTargets(playerSatellite);
        this.updateSelectedTarget(null);
    }

    public void updateTargets(Satellite satellite) {
        DiscoverySystem discoverySystem = satellite.getSystem(DiscoverySystem.class);
        this.centerHUD.setTargets(discoverySystem.getProximitySensor().getAllTargets());
        this.targetList.updateWith(discoverySystem.getProximitySensor().getAllTargets(5));
        this.bookmarkList.updateWith(discoverySystem.getTargetComputer().getBookmarkSensor().getAllTargets(5));
    }

    public void updateBookmarks(Satellite satellite) {
        DiscoverySystem discoverySystem = satellite.getSystem(DiscoverySystem.class);
        this.bookmarkList.updateWith(discoverySystem.getTargetComputer().getBookmarkSensor().getAllTargets(5));
        this.centerHUD.setBookmarks(discoverySystem.getTargetComputer().getBookmarkSensor().getAllTargets(5));
    }

    public void refreshTargetListIcon(EntityID entityID) {
        this.targetList.getTargetList().refreshTargetIcon(entityID);
    }

    public void updatePlayerInfo(Player player) {
        this.topBar.update(player.getChips(), player.getDiscoveryPoints());
    }

    public ObjectHUD getObjectHUD() {
        return this.objectHUD;
    }

    public CenterHUD getCenterHUD() {
        return this.centerHUD;
    }

    @Override
    public void act(float delta) {
        super.act(delta);
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        if (!batch.isDrawing()) {
            batch.begin();
        }
        this.centerHUD.render(this.factory.getHudRenderContext().getShapeDrawer(), Gdx.graphics.getDeltaTime());
        this.centerHUD.draw(batch);
        super.draw(batch, parentAlpha);
    }

    class HUDMessage {
        Message message;
        float restingTime;

        public HUDMessage(Message message, float restingTime) {
            this.message = message;
            this.restingTime = restingTime;
        }
    }
}

