/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.hud;

import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.action.CustomAction;
import com.neutronio.astrax.ui.commons.buttons.AstraXButton;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;

public class HUDActionPanel
extends SimplePanel {
    protected AstraXButton resetCameraButton;
    protected AstraXButton undockButton;
    protected AstraXButton bookmarkButton;
    private HUDActionPanelListener listener;

    public HUDActionPanel(ComponentFactory factory) {
        super(factory, "buttons", null);
        this.resetCameraButton = new AstraXButton(factory, "icon_inline_camera", "primary");
        this.resetCameraButton.setCanCheck(false);
        this.resetCameraButton.setDisabled(true);
        this.resetCameraButton.setButtonAction(CustomAction.get(new Runnable(){

            @Override
            public void run() {
                if (HUDActionPanel.this.listener != null) {
                    HUDActionPanel.this.listener.onCameraResetButtonClicked();
                }
            }
        }));
        this.undockButton = new AstraXButton(factory, "icon_inline_undock", "primary");
        this.undockButton.setCanCheck(false);
        this.undockButton.setDisabled(true);
        this.undockButton.setButtonAction(CustomAction.get(new Runnable(){

            @Override
            public void run() {
                if (HUDActionPanel.this.listener != null) {
                    HUDActionPanel.this.listener.onUndockButtonClicked();
                }
            }
        }));
        this.bookmarkButton = new AstraXButton(factory, "icon_inline_bookmark", "primary");
        this.bookmarkButton.setCanCheck(false);
        this.bookmarkButton.setDisabled(true);
        this.bookmarkButton.setButtonAction(CustomAction.get(new Runnable(){

            @Override
            public void run() {
                if (HUDActionPanel.this.listener != null) {
                    HUDActionPanel.this.listener.onBookmarkButtonClicked();
                }
            }
        }));
        this.addValue(this.resetCameraButton).center();
        this.addValue(this.bookmarkButton).center();
        this.addValue(this.undockButton).center();
        this.pack();
    }

    public AstraXButton getResetCameraButton() {
        return this.resetCameraButton;
    }

    public AstraXButton getUndockButton() {
        return this.undockButton;
    }

    public AstraXButton getBookmarkButton() {
        return this.bookmarkButton;
    }

    public void setListener(HUDActionPanelListener listener) {
        this.listener = listener;
    }

    public static interface HUDActionPanelListener {
        public void onCameraResetButtonClicked();

        public void onUndockButtonClicked();

        public void onBookmarkButtonClicked();
    }
}

