/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.hud;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;

public class IconPointer
extends Group {
    private IconPointerStyle style;
    private Image icon;
    private Image iconPointer = new Image();

    public IconPointer(Skin skin) {
        this.icon = new Image();
        this.addActor(this.iconPointer);
        this.addActor(this.icon);
        this.setStyle(new IconPointerStyle(skin.get(IconPointerStyle.class)));
        this.iconPointer.setPosition(this.style.offsetX, this.style.offsetY);
    }

    public IconPointerStyle getStyle() {
        return this.style;
    }

    public void setIconPointerColor(Color color) {
        this.iconPointer.setColor(color);
    }

    public void setIconDrawable(Drawable icon) {
        this.icon.setDrawable(icon);
        this.icon.setColor(this.style.iconColor);
        this.icon.setAlign(1);
        this.icon.setSize(icon.getMinWidth(), icon.getMinHeight());
        this.icon.setPosition((icon.getMinWidth() + 6.0f) / 2.0f - icon.getMinWidth() / 2.0f, (icon.getMinHeight() + 5.0f) / 2.0f - icon.getMinHeight() / 2.0f);
    }

    public void setStyle(IconPointerStyle style) {
        this.style = style;
        this.iconPointer.setDrawable(style.iconPointer);
        this.iconPointer.setColor(style.iconPointerColor);
        this.iconPointer.setOrigin(style.centerOfRotationX, style.centerOfRotationY);
        this.iconPointer.setSize(style.iconPointer.getMinWidth(), style.iconPointer.getMinHeight());
        this.icon.setDrawable(style.icon);
        this.icon.setColor(style.iconColor);
        this.icon.setAlign(1);
        this.icon.setSize(style.icon.getMinWidth(), style.icon.getMinHeight());
        this.icon.setPosition((style.icon.getMinWidth() + 6.0f) / 2.0f - style.icon.getMinWidth() / 2.0f, (style.icon.getMinHeight() + 5.0f) / 2.0f - style.icon.getMinHeight() / 2.0f);
        this.setSize(style.icon.getMinWidth() + 5.0f, style.icon.getMinHeight() + 5.0f);
    }

    public void setDirection(float degrees) {
        this.iconPointer.setRotation(degrees + this.style.angleOffset);
    }

    public static class IconPointerStyle {
        public Drawable iconPointer;
        public Color iconPointerColor;
        public Drawable icon;
        public Color iconColor;
        public float offsetX = 0.0f;
        public float offsetY = 0.0f;
        public float angleOffset = 45.0f;
        public float centerOfRotationX = 0.0f;
        public float centerOfRotationY = 0.0f;

        public IconPointerStyle() {
        }

        public IconPointerStyle(IconPointerStyle style) {
            this.icon = style.icon;
            this.iconPointer = style.iconPointer;
            this.offsetX = style.offsetX;
            this.offsetY = style.offsetY;
            this.angleOffset = style.angleOffset;
            this.centerOfRotationX = style.centerOfRotationX;
            this.centerOfRotationY = style.centerOfRotationY;
            this.iconColor = style.iconColor.cpy();
            this.iconPointerColor = style.iconPointerColor.cpy();
        }

        public String toString() {
            return "IconPointerStyle{iconPointer=" + this.iconPointer + ", icon=" + this.icon + ", offsetX=" + this.offsetX + ", offsetY=" + this.offsetY + ", centerOfRotationX=" + this.centerOfRotationX + ", centerOfRotationY=" + this.centerOfRotationY + '}';
        }
    }
}

