/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.hud;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.neutronio.astrax.app.Message;
import com.neutronio.astrax.ui.commons.buttons.StaticIcon;
import com.neutronio.astrax.util.animation.Tweening;

public class Notification
extends Table {
    private Skin skin;
    private Message message;
    private Label label;
    private StaticIcon icon;
    private Image background;

    public Notification(Skin skin) {
        super(skin);
        this.skin = skin;
        this.background = new Image();
        this.background.setDrawable(skin.getDrawable("icon_bg_para_f_n"));
        this.background.setColor(Color.WHITE);
        this.background.setAlign(1);
        this.background.setOrigin(this.background.getWidth() / 2.0f, this.background.getHeight() / 2.0f);
        this.label = new Label("", skin, "transparent-large");
        this.icon = new StaticIcon(skin, "success");
        this.icon.setOrigin(this.icon.getWidth() / 2.0f, this.icon.getHeight() / 2.0f);
        this.addActor(this.background);
        HorizontalGroup group = new HorizontalGroup();
        group.space(15.0f);
        group.addActor(this.icon);
        group.addActor(this.label);
        this.add(group).padBottom(16.0f).padTop(16.0f).padLeft(18.0f).padRight(18.0f);
        this.pack();
    }

    @Override
    public void setSize(float width, float height) {
        super.setSize(width, height);
        this.background.setSize(this.getWidth(), this.getHeight());
    }

    public void displayMessage(Message message) {
        this.message = message;
        this.label.setText(message.getMessage());
        switch (message.getType()) {
            case SUCCESS: {
                this.background.setColor(this.skin.getColor("success"));
                this.label.setColor(this.skin.getColor("success-bright"));
                this.icon.setStyle(this.skin.get("success", StaticIcon.StaticIconStyle.class));
                break;
            }
            case INFO: {
                this.background.setColor(this.skin.getColor("info"));
                this.label.setColor(this.skin.getColor("info-bright"));
                this.icon.setStyle(this.skin.get("info", StaticIcon.StaticIconStyle.class));
                break;
            }
            case WARNING: {
                this.background.setColor(this.skin.getColor("warning"));
                this.label.setColor(this.skin.getColor("warning-bright"));
                this.icon.setStyle(this.skin.get("warning", StaticIcon.StaticIconStyle.class));
            }
            case ALERT: 
            case EXCEPTION: {
                this.background.setColor(this.skin.getColor("error"));
                this.label.setColor(this.skin.getColor("error-bright"));
                this.icon.setStyle(this.skin.get("error", StaticIcon.StaticIconStyle.class));
            }
        }
        this.icon.setOrigin(this.icon.getWidth() / 2.0f, this.icon.getHeight() / 2.0f);
        this.icon.addAction(Actions.repeat(3, Tweening.getSquish(3.0f)));
        this.pack();
    }

    public Message getMessage() {
        return this.message;
    }
}

