/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.hud;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.datapack.game.DiscoveryTarget;
import com.neutronio.astrax.app.datapack.game.world.AsteroidTarget;
import com.neutronio.astrax.app.datapack.game.world.CelestialTarget;
import com.neutronio.astrax.app.datapack.game.world.SatelliteTarget;
import com.neutronio.astrax.app.datapack.game.world.galaxy.asteroid.Asteroid;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.Satellite;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.targeting.DiscoveryDatabank;
import com.neutronio.astrax.gfx.AsteroidGraphics;
import com.neutronio.astrax.gfx.AsteroidGraphicsFactory;
import com.neutronio.astrax.gfx.SatelliteGraphics;
import com.neutronio.astrax.gfx.entities.PlanetGraphics;
import com.neutronio.astrax.gfx.factories.SatelliteGraphicsFactory;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.AstraXComponent;
import com.neutronio.astrax.ui.commons.Separator;
import com.neutronio.astrax.ui.game.TraitIconArray;
import com.neutronio.astrax.util.StandardFormats;
import java.util.List;

public class ObjectHUD
extends AstraXComponent {
    private DiscoveryDatabank discoveryDatabank;
    private String unknownTarget = "placeholder_target_unknown";
    private float objectContainerSize = 100.0f;
    private Actor graphics;
    private Stack targetGraphicsStack;
    private Image targetGraphicsBackground;
    private Label nameLabel;
    private Label discoveredLabel;
    private Separator separator;
    private TraitIconArray traits;
    private AsteroidGraphicsFactory asteroidGraphicsFactory = AstraXApp.astraX.getFactoryByClass(AsteroidGraphicsFactory.class);
    private SatelliteGraphicsFactory satelliteGraphicsFactory = AstraXApp.astraX.getFactoryByClass(SatelliteGraphicsFactory.class);

    public ObjectHUD(ComponentFactory factory) {
        super(factory, "transparent");
        this.targetGraphicsBackground = new Image(new TextureRegionDrawable(factory.getSkin().getRegion("placeholder_targetHUD")));
        this.targetGraphicsBackground.setSize(this.objectContainerSize + 40.0f, this.objectContainerSize + 40.0f);
        this.targetGraphicsStack = new Stack();
        this.targetGraphicsStack.add(this.targetGraphicsBackground);
        this.targetGraphicsStack.pack();
        this.nameLabel = new Label("No Target", factory.getSkin(), "default-no-bg");
        this.nameLabel.setAlignment(1);
        this.discoveredLabel = new Label("", factory.getSkin(), "default-no-bg");
        this.discoveredLabel.setAlignment(1);
        this.traits = new TraitIconArray(factory.getSkin());
        this.traits.setMaxIconsInRow(4);
        this.separator = new Separator(factory.getSkin(), "separator_horizontal_1");
    }

    @Override
    public void construct() {
        super.construct();
        this.addActor(this.targetGraphicsStack);
        this.targetGraphicsStack.setSize(this.objectContainerSize + 20.0f, this.objectContainerSize + 20.0f);
        this.add().minSize(this.objectContainerSize + 20.0f, this.objectContainerSize + 20.0f).pad(20.0f);
        Table panel = new Table();
        panel.add(this.nameLabel).top().padBottom(5.0f).padTop(5.0f).minWidth(200.0f);
        panel.row();
        panel.add(this.discoveredLabel).top().padBottom(10.0f);
        panel.row();
        panel.add(this.separator).minHeight(10.0f).padBottom(5.0f).fill();
        panel.row();
        panel.add(this.traits).center();
        this.add(panel).padTop(20.0f).top();
        this.pack();
        this.targetGraphicsStack.setPosition(10.0f, this.getHeight() / 2.0f - this.targetGraphicsStack.getHeight() / 2.0f - 10.0f);
    }

    public void setDiscoveryDatabank(DiscoveryDatabank discoveryDatabank) {
        this.discoveryDatabank = discoveryDatabank;
    }

    public void updateWith(DiscoveryTarget discoveryTarget) {
        if (discoveryTarget == null) {
            this.nameLabel.setText("No Target");
            this.discoveredLabel.setText("");
            this.traits.updateWith(null);
            if (this.graphics != null) {
                this.graphics.remove();
            }
            return;
        }
        this.nameLabel.setText(discoveryTarget.getName());
        if (discoveryTarget.discovery == null) {
            this.traits.updateWith(null);
            this.discoveredLabel.setText("n.A.");
            if (this.graphics != null) {
                this.graphics.remove();
            }
            return;
        }
        List<String> icons = this.discoveryDatabank.getIconsFor(discoveryTarget.target.getID());
        this.traits.updateWith(icons);
        if (discoveryTarget.discovery != null) {
            this.discoveredLabel.setText(StandardFormats.PERCENT.format(Float.valueOf(discoveryTarget.discovery.discoveredFactor * 100.0f)) + " %");
        } else {
            this.discoveredLabel.setText(StandardFormats.PERCENT.format(Float.valueOf(0.0f)) + " %");
        }
        if (this.graphics != null) {
            this.graphics.remove();
        }
        if (discoveryTarget.target instanceof CelestialTarget) {
            PlanetGraphics copy = ((PlanetGraphics)((CelestialTarget)discoveryTarget.target).getGraphics()).copy();
            copy.setPlanetSize((int)this.objectContainerSize, (int)this.objectContainerSize);
            copy.updateSize();
            this.graphics = copy;
            this.targetGraphicsStack.add(this.graphics);
        } else if (discoveryTarget.target instanceof AsteroidTarget) {
            AsteroidGraphics asteroidGraphics = this.asteroidGraphicsFactory.create(((Asteroid)((AsteroidTarget)discoveryTarget.target).getModel()).getSettings());
            this.graphics = asteroidGraphics;
            this.targetGraphicsStack.add(this.graphics);
        } else if (discoveryTarget.target instanceof SatelliteTarget) {
            SatelliteGraphics satelliteGraphics = this.satelliteGraphicsFactory.createGraphics(((Satellite)((SatelliteTarget)discoveryTarget.target).getModel()).getSatelliteGrid());
            this.graphics = satelliteGraphics;
            this.targetGraphicsStack.add(this.graphics);
        }
    }
}

