/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.hud;

import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.IconLabel;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;
import com.neutronio.astrax.util.StandardFormats;
import java.util.HashMap;
import java.util.Map;

public class ResourceDisplay
extends SimplePanel {
    private Map<String, IconLabel> display = new HashMap<String, IconLabel>();
    private StandardFormats format = StandardFormats.MONEY_HUD;

    public ResourceDisplay(ComponentFactory componentFactory) {
        super(componentFactory);
    }

    public void setFormat(StandardFormats format) {
        this.format = format;
    }

    public IconLabel addDisplayedResource(String id, String icon) {
        IconLabel iconLabel = new IconLabel(this.componentFactory, "hud", "arrows");
        iconLabel.setText(this.format.format(0));
        iconLabel.setIcon(icon);
        this.display.put(id, iconLabel);
        return iconLabel;
    }

    public void setDisplayedResource(String id, int amount) {
        if (!this.display.containsKey(id)) {
            return;
        }
        this.display.get(id).setText(this.format.format(amount));
    }

    @Override
    public void construct() {
        for (IconLabel iconLabel : this.display.values()) {
            this.addValue(iconLabel);
        }
        this.pack();
    }
}

