/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.hud;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.neutronio.astrax.gfx.ShapeGraphics;
import com.neutronio.astrax.ui.hud.ShapeStyle;
import space.earlygrey.shapedrawer.ShapeDrawer;

public class ShapeTargetor
implements ShapeGraphics {
    protected ShapeStyle style;
    private ShapeType shapeType = ShapeType.CIRCLE;
    private float maxOffset = 50.0f;
    private float time;

    public ShapeTargetor(Skin skin) {
        this.setStyle(skin.get("default", ShapeStyle.class));
    }

    public void setStyle(ShapeStyle style) {
        this.style = style;
    }

    public ShapeStyle getStyle() {
        return this.style;
    }

    public void setShapeType(ShapeType shapeType) {
        this.shapeType = shapeType;
    }

    private void renderCircleSnake(ShapeDrawer shapeDrawer, float x, float y, float width, float height) {
        float currentTime = this.time + Interpolation.sine.apply(0.0f, 5.0f, this.time);
        float arcLength = 1.5707964f;
        shapeDrawer.setColor(this.style.color);
        shapeDrawer.arc(x + width / 2.0f, y + height / 2.0f, width / 2.0f, currentTime, arcLength);
        shapeDrawer.arc(x + width / 2.0f, y + height / 2.0f, width / 2.0f, currentTime - (float)Math.PI, arcLength);
    }

    public void render(ShapeDrawer shapeDrawer, float x, float y, float width, float height, float delta) {
        this.time += delta * 1.5f;
        Gdx.gl.glEnable(3042);
        Gdx.gl.glBlendFunc(770, 771);
        float sizeFactor = (width + height) / 2.0f / 5000.0f;
        float currentOffset = Interpolation.sine.apply(0.0f, this.maxOffset, this.time);
        float currentAlpha = Interpolation.sine.apply(0.0f, 1.0f, this.time);
        float lineWidth = Interpolation.pow2.apply(this.style.defaultLineWidth, (float)this.style.defaultLineWidth * 2.5f, sizeFactor);
        switch (this.shapeType) {
            case CIRCLE: {
                shapeDrawer.setDefaultLineWidth(lineWidth);
                shapeDrawer.setColor(this.style.selectionColor);
                shapeDrawer.circle(x + width / 2.0f, y + height / 2.0f, width / 2.0f);
                shapeDrawer.setDefaultLineWidth(lineWidth * 0.9f);
                shapeDrawer.setColor(this.style.color.r, this.style.color.g, this.style.color.b, currentAlpha);
                shapeDrawer.circle(x + width / 2.0f, y + width / 2.0f, width / 2.0f + currentOffset);
                shapeDrawer.circle(x + width / 2.0f, y + width / 2.0f, width / 2.0f - MathUtils.clamp(currentOffset, 20.0f, width / 2.0f));
                shapeDrawer.setDefaultLineWidth(lineWidth);
                this.renderCircleSnake(shapeDrawer, x, y, width, height);
                break;
            }
            case RECTANGLE: {
                shapeDrawer.setColor(this.style.selectionColor);
                shapeDrawer.rectangle(x, y, width, height);
                shapeDrawer.setDefaultLineWidth(lineWidth);
                shapeDrawer.setColor(this.style.color.r, this.style.color.g, this.style.color.b, currentAlpha);
                shapeDrawer.rectangle(x - currentOffset / 2.0f, y - currentOffset / 2.0f, width + currentOffset, height + currentOffset);
            }
        }
    }

    public static enum ShapeType {
        CIRCLE,
        RECTANGLE;

    }
}

