/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.hud;

import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.ProgressBar;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.Satellite;

public class ShipStatusHUD
extends Group {
    private Skin skin;
    private ProgressBar hpbar;
    private Image overlay;
    private ShipStatusHUDStyle style;

    public ShipStatusHUD(Skin skin) {
        this.hpbar = new ProgressBar(0.0f, 1.0f, 0.001f, false, skin, "hp-bar");
        this.hpbar.setAnimateDuration(0.6f);
        this.hpbar.setAnimateInterpolation(Interpolation.pow2);
        this.hpbar.setValue(1.0f);
        this.overlay = new Image(skin, "hp_bar_bg");
        this.overlay.setSize(this.overlay.getDrawable().getMinWidth(), this.overlay.getDrawable().getMinHeight());
        this.hpbar.setSize(this.overlay.getDrawable().getMinWidth() - 64.0f, this.overlay.getDrawable().getMinHeight());
        this.hpbar.setPosition(20.0f, 13.0f);
        this.setSize(this.overlay.getDrawable().getMinWidth(), this.overlay.getDrawable().getMinHeight());
    }

    public ShipStatusHUDStyle getStyle() {
        return this.style;
    }

    public void setStyle(ShipStatusHUDStyle style) {
        this.style = style;
    }

    public void updateWith(Satellite ship) {
        float hp = ship.getHpCurrent() / ship.getHpMax();
        this.hpbar.setValue(hp);
    }

    public static class ShipStatusHUDStyle {
    }
}

