/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.hud;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.Satellite;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.sensors.MonitoringSystem;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.Background;
import com.neutronio.astrax.ui.hud.Gauge;

public class SpaceCraftDashboard
extends Group {
    private Background background;
    private Gauge oxygen;
    private Gauge fuel;
    private Gauge radiation2;
    private boolean init = false;

    public SpaceCraftDashboard(ComponentFactory componentFactory) {
        this.background = new Background(componentFactory.getSkin(), "border");
        this.addActor(this.background);
        this.oxygen = new Gauge(componentFactory, "icon_resource_oxygen", 60.0f);
        this.oxygen.setColor(componentFactory.getSkin().getColor("secondary-bright"));
        this.oxygen.addNeedle("stored", 16.0f, 60.0f, componentFactory.getSkin().getColor("info-bright"), componentFactory.getSkin().getColor("tertiary"));
        this.oxygen.setDisplayedNeedle("stored");
        this.oxygen.getNeedle("stored").setBlinkSound("alert2");
        this.oxygen.getNeedle("stored").setBlinkInterval(1.5f);
        this.oxygen.setPosition(90.0f, this.oxygen.radius);
        this.oxygen.setShapeDrawer(componentFactory.getHudRenderContext().getShapeDrawer());
        this.fuel = new Gauge(componentFactory, "icon_resource_rocketFuel", 40.0f);
        this.fuel.renderDialText = false;
        this.fuel.setColor(componentFactory.getSkin().getColor("secondary-bright"));
        this.fuel.addNeedle("stored", 16.0f, 38.0f, componentFactory.getSkin().getColor("warning-bright"), componentFactory.getSkin().getColor("tertiary"));
        this.fuel.getNeedle("stored").setBlinkSound("alert1");
        this.fuel.getNeedle("stored").setBlinkInterval(1.5f);
        this.fuel.addNeedle("consumption", 16.0f, 30.0f, componentFactory.getSkin().getColor("warning"), null);
        this.fuel.getNeedle("consumption").setBlinkingEnabled(false);
        this.fuel.getNeedle("consumption").setBaseValue(1.0f);
        this.fuel.getNeedle("consumption").setDrawValue(false);
        this.fuel.setDisplayedNeedle("stored");
        this.fuel.setPosition(240.0f, this.oxygen.radius);
        this.fuel.setShapeDrawer(componentFactory.getHudRenderContext().getShapeDrawer());
        this.addActor(this.oxygen);
        this.addActor(this.fuel);
        this.setSize(330.0f, 140.0f);
    }

    private void initialize(Satellite satellite) {
        this.oxygen.getNeedle("stored").setBaseValue(satellite.getOxygenMax());
        this.fuel.getNeedle("stored").setBaseValue(satellite.getFuelMax());
        float maxConsumption = satellite.getTankSystem().getTankManager().getCompartment("resource_rocketFuel").getMaxConsumption();
        this.fuel.getNeedle("consumption").setBaseValue(maxConsumption);
        this.oxygen.customizeMarkers("", "", satellite.getOxygenMax() + "");
        this.fuel.customizeMarkers("", "", satellite.getFuelMax() + "");
        if (satellite.hasSystem(MonitoringSystem.class)) {
            MonitoringSystem monitoringSystem = satellite.getSystem(MonitoringSystem.class);
            MonitoringSystem.Alert oxygenAlert = monitoringSystem.getAlertFor("resource_oxygen");
            MonitoringSystem.Alert rocketFuelAlert = monitoringSystem.getAlertFor("resource_rocketFuel");
            this.setupAlert(this.oxygen, oxygenAlert, satellite.getOxygenMax());
            this.setupAlert(this.fuel, rocketFuelAlert, satellite.getFuelMax());
        }
        this.init = true;
    }

    private void setupAlert(Gauge gauge, MonitoringSystem.Alert alert, float max) {
        float critical = alert.getMetric().getCriticalThreshold() / max;
        float warning = alert.getMetric().getWarningThreshold() / max;
        float info = alert.getMetric().getInfoThreshold() / max;
        gauge.addMarker("", (float)Math.toRadians(225.0) * (1.0f - critical), gauge.radius, gauge.radius * 0.8f, Color.RED);
        gauge.addMarker("", (float)Math.toRadians(225.0) * (1.0f - warning), gauge.radius, gauge.radius * 0.8f, Color.ORANGE);
        gauge.addMarker("", (float)Math.toRadians(225.0) * (1.0f - info), gauge.radius, gauge.radius * 0.8f, Color.YELLOW);
        gauge.getNeedle("stored").setBlinkBelow(critical);
    }

    public void updateGauges(Satellite spaceShip) {
        if (!this.init) {
            this.initialize(spaceShip);
        }
        this.oxygen.setNeedleValue("stored", spaceShip.getOxygenCurrentFactor());
        this.fuel.setNeedleValue("stored", spaceShip.getFuelCurrentFactor());
        float netRate = spaceShip.getTankSystem().getCompartments().get("resource_rocketFuel").getConsumption();
        this.fuel.setNeedleValue("consumption", Math.abs(netRate));
    }

    @Override
    protected void drawChildren(Batch batch, float parentAlpha) {
        this.background.setSize(this.getWidth(), this.getHeight());
        super.drawChildren(batch, parentAlpha);
    }
}

