/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.hud;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.neutronio.astrax.app.datapack.EntityID;
import com.neutronio.astrax.app.datapack.game.world.CelestialTarget;
import com.neutronio.astrax.app.datapack.game.world.NavTarget;
import com.neutronio.astrax.app.datapack.game.world.Targetable;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.sensors.TargetSorter;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.targeting.DiscoverySystem;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.buttons.ButtonGroup;
import com.neutronio.astrax.ui.commons.buttons.CompositeButton;
import com.neutronio.astrax.ui.game.BookmarkTrackerButton;
import com.neutronio.astrax.ui.game.TargetTrackerButton;
import com.neutronio.astrax.ui.game.TrackerButton;
import com.neutronio.astrax.ui.game.TrackerButtonListener;
import com.neutronio.astrax.util.StandardFormats;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class TargetList
extends Table {
    private String buttonBackgroundStyle;
    private DiscoverySystem discoverySystem;
    private ComponentFactory componentFactory;
    private ButtonGroup buttonGroup;
    private EntityID selected;
    private List<TrackerButton> icons = new ArrayList<TrackerButton>();
    private TrackerButtonListener listener;
    private boolean useBookmarks = false;

    public TargetList(ComponentFactory componentFactory, boolean useBookmarks) {
        super(componentFactory.getSkin());
        this.useBookmarks = useBookmarks;
        this.buttonBackgroundStyle = this.useBookmarks ? "transparent" : "bookmark";
        this.componentFactory = componentFactory;
        this.buttonGroup = new ButtonGroup();
    }

    public void setListener(TrackerButtonListener listener) {
        this.listener = listener;
        for (TrackerButton targetItem : this.icons) {
            targetItem.setTrackerButtonListener(this.listener);
        }
    }

    public void setDiscoverySystem(DiscoverySystem targetComputerr) {
        this.discoverySystem = targetComputerr;
    }

    public DiscoverySystem getDiscoverySystem() {
        return this.discoverySystem;
    }

    public void setShownTargetCount(int count) {
        for (int i2 = 0; i2 < count; ++i2) {
            CompositeButton button;
            CompositeButton trackerButton = null;
            if (this.useBookmarks) {
                button = new TargetTrackerButton(this.componentFactory, this.buttonBackgroundStyle);
                ((TargetTrackerButton)button).construct();
                button.setVisible(true);
                trackerButton = button;
            } else {
                button = new BookmarkTrackerButton(this.componentFactory, this.buttonBackgroundStyle);
                ((BookmarkTrackerButton)button).construct();
                button.setVisible(true);
                trackerButton = button;
            }
            trackerButton.setTrackerButtonListener(this.listener);
            trackerButton.setPointerRotation(0.0f);
            this.buttonGroup.add(trackerButton);
            this.icons.add((TrackerButton)((Object)trackerButton));
            this.add((Actor)trackerButton).pad(3.0f).row();
        }
        this.pack();
    }

    public EntityID getSelectedTargetID() {
        return this.selected;
    }

    public void selectTarget(EntityID ofEntityID) {
        if (ofEntityID == null) {
            this.selected = null;
            this.buttonGroup.uncheckAll();
            return;
        }
        for (TrackerButton target : this.icons) {
            if (target.getDiscoveryTarget() == null) continue;
            EntityID entityID = target.getDiscoveryTarget().target.getID();
            if (Objects.equals(entityID, ofEntityID)) {
                this.selected = ofEntityID;
                target.setChecked(true);
                continue;
            }
            target.setChecked(false);
        }
    }

    public void refreshTargetIcon(EntityID entityID) {
        for (TrackerButton targetItem : this.icons) {
            if (!Objects.equals(entityID, targetItem.getDiscoveryTarget())) continue;
            targetItem.setDisplay(targetItem.getDiscoveryTarget().getIcon());
        }
    }

    public void refresh(List<TargetSorter.Target> targets) {
        int i2;
        this.buttonGroup.uncheckAll();
        for (i2 = 0; i2 < this.icons.size() && i2 < targets.size(); ++i2) {
            TrackerButton targetItem = this.icons.get(i2);
            TargetSorter.Target target = targets.get(i2);
            Targetable targetable = target.getTargetable();
            ((Actor)((Object)targetItem)).setVisible(true);
            targetItem.setPointerRotation(targets.get(i2).getAngle());
            targetItem.setDiscoveryTarget(targets.get(i2).getDiscoveryTarget());
            String displayName = targets.get(i2).getDiscoveryTarget().getName();
            String displayIcon = targets.get(i2).getDiscoveryTarget().getIcon();
            EntityID entityID = target.getTargetable().getID();
            if (Objects.equals(entityID, this.selected)) {
                targetItem.setChecked(true);
            }
            targetItem.setDisplay(targetable.getID(), displayName, StandardFormats.DISTANCE.format(Float.valueOf(targets.get(i2).getDistance())) + " km", displayIcon);
            if (targetItem instanceof TargetTrackerButton) {
                TargetTrackerButton targetButton = (TargetTrackerButton)targetItem;
                boolean bookmarkDisabled = target.getDiscoveryTarget().discovery == null || target.getDiscoveryTarget().bookmark != null;
                targetButton.getBookmarkButton().setDisabled(bookmarkDisabled);
            }
            if (!(targetable instanceof NavTarget)) continue;
            NavTarget navTarget = (NavTarget)targetable;
            targetItem.setIconColor(navTarget.getParentBookmark().color);
        }
        while (i2 < this.icons.size()) {
            ((Actor)((Object)this.icons.get(i2))).setVisible(false);
            ++i2;
        }
    }

    @Deprecated
    public void updateWith(List<TargetSorter.Target> targets) {
        int i2;
        if (targets.size() > this.icons.size()) {
            for (i2 = this.icons.size(); i2 < targets.size(); ++i2) {
                TargetTrackerButton targetTrackerButton = new TargetTrackerButton(this.componentFactory);
                targetTrackerButton.construct();
                targetTrackerButton.setPointerRotation(targets.get(i2).getAngle());
                targetTrackerButton.setUserObject(targets.get(i2).getTargetable().getID());
                this.icons.add(targetTrackerButton);
                this.add(targetTrackerButton).pad(3.0f).row();
            }
        } else if (targets.size() < this.icons.size()) {
            for (i2 = targets.size(); i2 < this.icons.size(); ++i2) {
                TrackerButton removed = this.icons.remove(i2);
                ((Actor)((Object)removed)).remove();
            }
        }
        if (this.icons.size() == targets.size()) {
            for (i2 = 0; i2 < this.icons.size(); ++i2) {
                TrackerButton targetItem = this.icons.get(i2);
                targetItem.setPointerRotation(targets.get(i2).getAngle());
                Targetable targetable = targets.get(i2).getTargetable();
                if (!(targetable instanceof CelestialTarget)) continue;
                targetItem.setDisplay(targetable.getID(), targets.get(i2).getDiscoveryTarget().getName(), StandardFormats.DISTANCE.format(Float.valueOf(targets.get(i2).getDistance())) + " km", targets.get(i2).getDiscoveryTarget().getIcon());
                targetItem.setDiscoveryTarget(targets.get(i2).getDiscoveryTarget());
            }
        }
    }
}

