/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.hud;

import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.sensors.TargetSorter;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.buttons.AstraXTextButton;
import com.neutronio.astrax.ui.hud.TargetList;
import com.neutronio.astrax.util.animation.Tweening;
import java.util.List;

public class ToggableTargetList
extends Table {
    private String name;
    private ComponentFactory factory;
    private AstraXTextButton nameButton;
    private TargetList targetList;

    public ToggableTargetList(ComponentFactory factory, String name, boolean useBookmarks) {
        super(factory.getSkin());
        this.name = name;
        this.factory = factory;
        this.nameButton = new AstraXTextButton(this.factory, "secondary-compact");
        this.nameButton.setText(this.name);
        this.nameButton.setChecked(true, false);
        this.nameButton.setSquishable(false);
        this.nameButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                super.clicked(event, x, y);
                if (ToggableTargetList.this.targetList.isVisible()) {
                    ToggableTargetList.this.targetList.addAction(Tweening.getDefaultFadeOut(0.5f));
                } else {
                    ToggableTargetList.this.targetList.addAction(Tweening.getDefaultFadeIn(0.3f));
                }
            }
        });
        this.targetList = new TargetList(factory, useBookmarks);
        this.targetList.setShownTargetCount(5);
    }

    public void construct() {
        this.add(this.nameButton).fill();
        this.add().fill();
        this.row();
        this.add(this.targetList).colspan(2);
        this.pack();
    }

    public TargetList getTargetList() {
        return this.targetList;
    }

    public void updateWith(List<TargetSorter.Target> targets) {
        if (this.targetList.hasActions()) {
            return;
        }
        this.targetList.refresh(targets);
    }
}

