/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.hud;

import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.IconLabel;
import com.neutronio.astrax.ui.commons.buttons.StaticIcon;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;
import com.neutronio.astrax.ui.commons.text.TextProgressbar;
import com.neutronio.astrax.ui.hud.ResourceDisplay;
import com.neutronio.astrax.util.StandardFormats;

public class TopBar
extends SimplePanel {
    private ResourceDisplay resources;
    private TextProgressbar discovery;
    private TextProgressbar encumbrance;

    public TopBar(ComponentFactory componentFactory) {
        super(componentFactory, "default", "panel-tech-deco");
        this.discovery = new TextProgressbar(componentFactory);
        this.discovery.setBaseValue(1.0f);
        this.discovery.setUsePercent(true);
        this.discovery.setFormat(StandardFormats.PERCENT);
        this.discovery.setSize(300.0f, 32.0f);
        this.discovery.addListener(componentFactory.getToolTip(componentFactory.translate("game_hud_tooltip_discovered")));
        this.encumbrance = new TextProgressbar(componentFactory);
        this.encumbrance.setBaseValue(1.0f);
        this.encumbrance.setUsePercent(true);
        this.encumbrance.setFormat(StandardFormats.PERCENT);
        this.encumbrance.setSize(300.0f, 32.0f);
        this.encumbrance.addListener(componentFactory.getToolTip(componentFactory.translate("game_hud_tooltip_cargoCapacity")));
        this.resources = new ResourceDisplay(componentFactory);
        IconLabel chipsIconLabel = this.resources.addDisplayedResource("chips", "icon_resource_chipcoin");
        IconLabel discoveryIconLabel = this.resources.addDisplayedResource("discovery", "icon_research");
        this.resources.construct();
        chipsIconLabel.addListener(componentFactory.getToolTip(componentFactory.translate("game_hud_tooltip_chipCoin")));
        discoveryIconLabel.addListener(componentFactory.getToolTip(componentFactory.translate("game_hud_tooltip_discoveryPoints")));
        StaticIcon discoveryIcon = new StaticIcon(componentFactory.getSkin(), "secondary-32x32");
        discoveryIcon.setInlineIcon("icon_inline_discover");
        StaticIcon encumbranceIcon = new StaticIcon(componentFactory.getSkin(), "secondary-32x32");
        encumbranceIcon.setInlineIcon("icon_inline_weight");
        this.add(discoveryIcon).center().padRight(5.0f);
        this.addValue(this.discovery);
        this.add(encumbranceIcon).center().padRight(5.0f);
        this.addValue(this.encumbrance);
        this.addValue(this.resources);
        this.pack();
    }

    public void update(int chips, int discoveryPoints) {
        this.resources.setDisplayedResource("chips", chips);
        this.resources.setDisplayedResource("discovery", discoveryPoints);
    }

    public void updateEncumbrance(float encumbrance) {
        this.encumbrance.setValue(encumbrance);
    }

    public void updateDiscovery(float discovery) {
        this.discovery.setValue(discovery);
    }
}

