/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.main;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;
import com.neutronio.astrax.ui.commons.text.AstraXLabel;
import com.neutronio.astrax.ui.commons.widgets.Avatar;

public class CharacterInfo
extends SimplePanel {
    private AstraXLabel playerNameValue;
    private AstraXLabel playerRankValue;
    private AstraXLabel playerIDValue;
    private Avatar avatar;

    public CharacterInfo(ComponentFactory componentFactory) {
        super(componentFactory);
        this.avatar = new Avatar(componentFactory);
        this.avatar.setAvatar(new Image(this.componentFactory.getSkin().getDrawable("avatar_1")), 69, 80);
        this.avatar.setBackground("avatar");
        this.playerNameValue = new AstraXLabel(componentFactory, "", "default", "label");
        this.playerNameValue.setTouchable(Touchable.disabled);
        this.playerNameValue.setText("");
        this.playerNameValue.setAlignment(8, 1);
        this.playerRankValue = new AstraXLabel(componentFactory, "", "default", "label");
        this.playerRankValue.setText("");
        this.playerRankValue.setTouchable(Touchable.disabled);
        this.playerRankValue.setAlignment(8, 1);
        this.playerIDValue = new AstraXLabel(componentFactory, "", "small", "label");
        this.playerIDValue.setText("");
        this.playerIDValue.setTouchable(Touchable.disabled);
        this.playerIDValue.setAlignment(8, 1);
        Table infoGroup = new Table();
        infoGroup.add(this.playerIDValue).left().minWidth(this.panelStyle.minValueWidth).padBottom(this.panelStyle.rowPadding);
        infoGroup.row();
        infoGroup.add(this.playerNameValue).left().minWidth(this.panelStyle.minValueWidth).padBottom(this.panelStyle.rowPadding);
        infoGroup.row();
        infoGroup.add(this.playerRankValue).left().minWidth(this.panelStyle.minValueWidth);
        this.addValue(this.avatar).size(110.0f, 130.0f).padLeft(15.0f).padRight(20.0f);
        this.addValue(infoGroup);
        this.pack();
    }

    public void updateAvatar(Actor avatar) {
        if (avatar == null) {
            Image placeholder = new Image(this.componentFactory.getSkin().getDrawable("avatar_placeholder"));
            this.avatar.setAvatar(placeholder, 110, 130);
        } else {
            this.avatar.setAvatar(avatar, 110, 130);
        }
        this.pack();
    }

    public void update(String characterName, String characterRank, String characterID) {
        this.playerIDValue.setText(characterID);
        this.playerNameValue.setText(characterName);
        this.playerRankValue.setText(characterRank);
    }
}

