/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.main;

import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.neutronio.astrax.app.UserProfile;
import com.neutronio.astrax.gfx.factories.AvatarFactory;
import com.neutronio.astrax.ui.AstraXSkin;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.buttons.CompositeButton;
import com.neutronio.astrax.ui.main.CharacterInfo;
import java.util.List;

public class CharacterInfoButton
extends CompositeButton {
    private AvatarFactory avatarFactory = new AvatarFactory();
    private CharacterInfo characterInfo;
    private Group avatarGroup;

    public CharacterInfoButton(ComponentFactory factory) {
        super(factory);
        this.avatarFactory.setSkin((AstraXSkin)this.componentFactory.getSkin());
        this.avatarGroup = new Group();
        this.avatarGroup.setScale(3.67f);
        this.characterInfo = new CharacterInfo(factory);
        this.add(this.characterInfo);
        this.centerBackground();
    }

    public void update(UserProfile userProfile) {
        if (userProfile == null) {
            this.characterInfo.updateAvatar(null);
            this.characterInfo.update("               ", "               ", "               ");
        } else {
            List<Image> images = this.avatarFactory.create(userProfile.avatarTextureIndices, userProfile.avatarColorIndices, "avatar_human");
            this.avatarGroup.clear();
            for (Image image : images) {
                this.avatarGroup.addActor(image);
            }
            if (!this.avatarGroup.hasParent()) {
                this.characterInfo.updateAvatar(this.avatarGroup);
            }
            this.characterInfo.update(userProfile.playerName, "", userProfile.id);
        }
        this.centerBackground();
    }
}

