/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.main;

import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.VerticalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.ApplicationSettings;
import com.neutronio.astrax.app.GeneralSettings;
import com.neutronio.astrax.app.KeyMappingSettings;
import com.neutronio.astrax.app.SkinSettings;
import com.neutronio.astrax.app.VideoSettings;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.buttons.AstraXTextButton;
import com.neutronio.astrax.ui.commons.forms.AbstractForm;
import com.neutronio.astrax.ui.commons.forms.FormListener;
import com.neutronio.astrax.ui.commons.forms.GenericMultiFormContainer;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;
import com.neutronio.astrax.ui.commons.widgets.Modal;
import com.neutronio.astrax.ui.game.GameSettingsPanel;
import com.neutronio.astrax.ui.game.InputControlsForm;
import com.neutronio.astrax.ui.game.SkinSettingsForm;
import com.neutronio.astrax.ui.game.VideoSettingsForm;
import com.neutronio.astrax.ui.main.SettingsResetPanel;
import java.util.ArrayList;
import java.util.List;

public class MainSettingsTab
extends SimplePanel
implements SettingsResetPanel.ResetPanelListener,
FormListener {
    private GenericMultiFormContainer multiFormContainer;
    private GameSettingsPanel gameSettingsPanel;
    private InputControlsForm inputControlsForm;
    private VideoSettingsForm videoSettingsForm;
    private SkinSettingsForm skinSettingsForm;
    private SettingsResetPanel settingsResetPanel;
    private Modal<SettingsResetPanel> settingsResetPanelModal;

    public MainSettingsTab(ComponentFactory factory, String style) {
        super(factory, style, "outset");
        this.gameSettingsPanel = new GameSettingsPanel(factory, "detailpanel", "tab-inner");
        this.gameSettingsPanel.construct();
        this.gameSettingsPanel.setName(this.componentFactory.translate("settings_general"));
        this.gameSettingsPanel.top();
        this.videoSettingsForm = new VideoSettingsForm(factory, "detailpanel", "tab-inner");
        this.videoSettingsForm.construct();
        this.videoSettingsForm.setName(this.componentFactory.translate("settings_video"));
        this.videoSettingsForm.top();
        this.inputControlsForm = new InputControlsForm(factory, "detailpanel", "tab-inner");
        this.inputControlsForm.setName(this.componentFactory.translate("settings_controls"));
        this.inputControlsForm.top();
        this.skinSettingsForm = new SkinSettingsForm(factory, "default", "outset");
        this.skinSettingsForm.setName(this.componentFactory.translate("settings_gui"));
        this.skinSettingsForm.construct();
        this.settingsResetPanel = new SettingsResetPanel(this.componentFactory);
        this.settingsResetPanelModal = new Modal<SettingsResetPanel>(this.componentFactory, this.settingsResetPanel);
        this.settingsResetPanelModal.setHeaderIcon("icon_inline_cog");
        this.settingsResetPanelModal.setHeaderText("Factory Reset");
        this.settingsResetPanel.setListener(this);
        ArrayList<AbstractForm> forms = new ArrayList<AbstractForm>();
        forms.add(this.gameSettingsPanel);
        forms.add(this.skinSettingsForm);
        forms.add(this.videoSettingsForm);
        forms.add(this.inputControlsForm);
        this.multiFormContainer = MainSettingsTab.createFormContainer(this.componentFactory, forms, true);
        this.multiFormContainer.getFormController().addListener(this);
        this.multiFormContainer.tabController.getStackController().show(0);
        this.add(this.multiFormContainer).top().fill();
        this.construct();
    }

    public MainSettingsTab(ComponentFactory factory) {
        this(factory, "default");
    }

    public GenericMultiFormContainer getMultiFormContainer() {
        return this.multiFormContainer;
    }

    public void applyStarterValues(ApplicationSettings applicationSettings) {
        this.gameSettingsPanel.load(applicationSettings.generalSettings);
        this.inputControlsForm.load(applicationSettings.keyMappingSettings);
        this.videoSettingsForm.load(applicationSettings.videoSettings);
        this.skinSettingsForm.load(applicationSettings.skinSettings);
    }

    public void showResetModal() {
        this.settingsResetPanelModal.show();
    }

    public InputControlsForm getInputControlsForm() {
        return this.inputControlsForm;
    }

    public void setInputControlsForm(InputControlsForm inputControlsForm) {
        this.inputControlsForm = inputControlsForm;
    }

    public Modal<SettingsResetPanel> getSettingsResetPanelModal() {
        return this.settingsResetPanelModal;
    }

    @Override
    public void onReset(Boolean gameSettings, Boolean inputSettings, Boolean video, Boolean skin) {
        if (gameSettings.booleanValue()) {
            AstraXApp.astraX.getApplicationSettings().generalSettings = new GeneralSettings();
        }
        if (inputSettings.booleanValue()) {
            AstraXApp.astraX.getApplicationSettings().generalSettings = new GeneralSettings();
        }
        if (video.booleanValue()) {
            AstraXApp.astraX.getApplicationSettings().videoSettings = new VideoSettings();
        }
        if (skin.booleanValue()) {
            AstraXApp.astraX.getApplicationSettings().skinSettings = SkinSettings.getDefaultSkinSettings();
        }
        AstraXApp.astraX.applyGameSettings(AstraXApp.astraX.getApplicationSettings());
        AstraXApp.astraX.saveApplicationData(AstraXApp.astraX.getApplicationSettings());
        this.applyStarterValues(AstraXApp.astraX.getApplicationSettings());
        this.settingsResetPanelModal.hide();
    }

    @Override
    public void onBack() {
        this.settingsResetPanelModal.hide();
    }

    @Override
    public void onFormSubmit(AbstractForm form) {
        if (form instanceof GameSettingsPanel) {
            GameSettingsPanel gameSettingsPanel = (GameSettingsPanel)form;
            gameSettingsPanel.applyValuesTo(AstraXApp.astraX.getApplicationSettings().generalSettings);
            AstraXApp.astraX.applyGameSettings(AstraXApp.astraX.getApplicationSettings());
        } else if (form instanceof InputControlsForm) {
            KeyMappingSettings keyMappingSettings = new KeyMappingSettings();
            InputControlsForm inputControlsForm = (InputControlsForm)form;
            inputControlsForm.applyValuesTo(keyMappingSettings);
            AstraXApp.astraX.getApplicationSettings().keyMappingSettings.merge(keyMappingSettings);
            AstraXApp.astraX.applyGameSettings(AstraXApp.astraX.getApplicationSettings());
        } else if (form instanceof VideoSettingsForm) {
            VideoSettingsForm videoSettingsForm = (VideoSettingsForm)form;
            videoSettingsForm.applyValuesTo(AstraXApp.astraX.getApplicationSettings().videoSettings);
        } else if (form instanceof SkinSettingsForm) {
            SkinSettingsForm skinSettingsForm = (SkinSettingsForm)form;
            skinSettingsForm.applyValuesTo(AstraXApp.astraX.getApplicationSettings().skinSettings);
        }
        AstraXApp.astraX.saveApplicationData(AstraXApp.astraX.getApplicationSettings());
    }

    @Override
    public void onFormCancel(AbstractForm form) {
    }

    @Override
    public void onFormReset(AbstractForm form) {
        AstraXApp.astraX.showInfoAlert(this.getTranslation("settings_message_reset"));
    }

    @Override
    public void onFormAction(AbstractForm form, String action) {
    }

    public static GenericMultiFormContainer createFormContainer(ComponentFactory componentFactory, List<AbstractForm> forms, boolean vertical) {
        AstraXTextButton tabButton;
        WidgetGroup tabButtons;
        GenericMultiFormContainer formContainer = new GenericMultiFormContainer(componentFactory);
        int colspan = 4;
        if (vertical) {
            tabButtons = new VerticalGroup();
            ((VerticalGroup)tabButtons).space(10.0f);
            ((VerticalGroup)tabButtons).top();
            for (AbstractForm form : forms) {
                formContainer.getFormController().putForm(form);
                tabButton = formContainer.tabController.addTabWithTextButton(form.getName(), "secondary-tab", form);
                tabButtons.addActor(tabButton);
            }
            formContainer.add(tabButtons).padRight(10.0f).top();
        } else {
            tabButtons = new HorizontalGroup();
            ((HorizontalGroup)tabButtons).space(10.0f);
            ((HorizontalGroup)tabButtons).top();
            for (AbstractForm form : forms) {
                formContainer.getFormController().putForm(form);
                tabButton = formContainer.tabController.addTabWithTextButton(form.getName(), "secondary-tab", form);
                tabButtons.addActor(tabButton);
            }
            formContainer.add(tabButtons).padBottom(10.0f).colspan(colspan).top();
            formContainer.row();
        }
        formContainer.addValue(formContainer.tabController.getContentStack()).colspan(colspan).top();
        formContainer.row();
        AstraXTextButton backButton = formContainer.multiFormController.addBackButton(componentFactory.translate("form_back"));
        backButton.setSquishable(false);
        formContainer.addValueCentered(backButton).minWidth(120.0f);
        AstraXTextButton restoreDefaultsButton = formContainer.multiFormController.addCustomButton(componentFactory.translate("form_restore_default"), "secondary", "restoreDefault");
        restoreDefaultsButton.setSquishable(false);
        formContainer.addValueCentered(restoreDefaultsButton).minWidth(120.0f);
        AstraXTextButton resetButton = formContainer.multiFormController.addResetButton(componentFactory.translate("form_reset"));
        resetButton.setSquishable(false);
        formContainer.addValueCentered(resetButton).minWidth(120.0f);
        AstraXTextButton submitButton = formContainer.multiFormController.addSubmitButton(componentFactory.translate("form_save"));
        submitButton.setSquishable(false);
        formContainer.addValueCentered(submitButton).minWidth(120.0f);
        formContainer.pack();
        return formContainer;
    }
}

